/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth;

import com.ki11erwolf.resynth.ResynthRecipes;
import com.ki11erwolf.resynth.proxy.ClientProxy;
import com.ki11erwolf.resynth.proxy.Proxy;
import com.ki11erwolf.resynth.proxy.ServerProxy;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.StackLocatorUtil;

@Mod(value="resynth")
public class ResynthMod {
    private static final Logger LOG = ResynthMod.getNewLogger();
    public static final String MODID = "resynth";
    public static final String MOD_VERSION = "6.1.1";
    public static final String MC_VERSION = "[1.16.5]";
    private static final Proxy proxy = (Proxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public ResynthMod() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.register((Object)ResynthRecipes.INSTANCE);
        modBus.register((Object)this);
        modBus.addListener(this::onSetup);
        modBus.addListener(this::onFinishSetup);
        modBus.addListener(this::onClientSetup);
        modBus.addListener(this::onEnqueueModComs);
        modBus.addListener(this::onProcessModComs);
    }

    public static Logger getNewLogger() {
        return LogManager.getLogger((Class)StackLocatorUtil.getCallerClass((int)2));
    }

    private void onSetup(FMLCommonSetupEvent event) {
        LOG.info(String.format("Beginning setup for Resynth, version '%s'...", MOD_VERSION));
        proxy.onSetup(event);
    }

    private void onFinishSetup(FMLLoadCompleteEvent event) {
        LOG.info("Finishing Resynth setup...");
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        if (proxy instanceof ClientProxy) {
            proxy.onClientSetup(event);
        }
    }

    private void onEnqueueModComs(InterModEnqueueEvent event) {
        proxy.onEnqueueModComs(event);
    }

    private void onProcessModComs(InterModProcessEvent event) {
        proxy.onProcessModComs(event);
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        proxy.onServerStarting(event);
    }

    @SubscribeEvent
    public static void onServerStopped(FMLServerStoppedEvent event) {
        if (!(proxy instanceof ClientProxy)) {
            proxy.onServerStopped(event);
        }
    }
}

