/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.ResynthPlants;
import com.ki11erwolf.resynth.block.BrittleBlock;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.item.ResynthItems;
import com.ki11erwolf.resynth.plant.set.PlantSetAPI;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Logger;

public enum ResynthRecipes implements IResourceManagerReloadListener
{
    INSTANCE(PlantSetAPI.getPlantSetRecipes(), CoreRecipes.INSTANCE, BrittleBlock.BrittleBlockRecipes.INSTANCE);

    private static final Logger LOG;
    private final List<IRecipe<?>> recipes = new ArrayList();
    private final RecipeProvider[] recipeProviders;
    private RecipeManager recipeManager;

    private ResynthRecipes(RecipeProvider ... providers) {
        this.recipeProviders = Objects.requireNonNull(providers);
    }

    private List<IRecipe<?>> buildRecipes() {
        LOG.info("Building the list of Resynth's custom recipes...");
        for (RecipeProvider provider : this.recipeProviders) {
            IRecipe<?>[] providerRecipes = provider.get();
            if (providerRecipes == null || providerRecipes.length == 0) {
                LOG.warn("Resynth RecipeProvider '" + provider.getClass().getCanonicalName() + "' provided no recipes!");
                continue;
            }
            for (IRecipe<?> recipe : providerRecipes) {
                if (recipe == null) {
                    LOG.warn("Resynth RecipeProvider '" + provider.getClass().getCanonicalName() + "' provided a NULL recipe!");
                    continue;
                }
                this.recipes.add(recipe);
                LOG.debug(String.format("Registered Resynth recipe: '%s' -> %s", recipe.func_199560_c().toString(), (recipe.func_77571_b().func_77973_b().getRegistryName() != null ? recipe.func_77571_b().func_77973_b().getRegistryName().toString() : "<NO REG NAME>") + "(" + recipe.func_77571_b().func_190916_E() + ")"));
            }
        }
        return this.recipes;
    }

    private List<IRecipe<?>> getRecipes() {
        if (this.recipes.size() != 0) {
            return this.recipes;
        }
        return this.buildRecipes();
    }

    public void func_195410_a(IResourceManager resourceManager) {
        ResynthMod.getNewLogger().info("Injecting Resynth's custom recipes for plants & plant sets...");
        this.register(this.getRecipes());
    }

    private void register(List<IRecipe<?>> recipes) {
        Field recipesField = this.getRecipesField();
        recipes = new ArrayList(recipes);
        recipes.addAll(this.getRecipeManager().func_199510_b());
        this.setRecipesField(recipesField, this.recipesToMap(recipes));
    }

    private Field getRecipesField() {
        Field recipesField;
        List<String> fieldNames = Arrays.asList("recipes", "field_199522_d");
        try {
            recipesField = Arrays.stream(RecipeManager.class.getDeclaredFields()).filter(field -> fieldNames.contains(field.getName())).findFirst().orElseThrow(() -> new NoSuchFieldException("Could not find field 'RecipeManager.recipes' under any known name"));
            recipesField.setAccessible(true);
            Object fieldObjectRef = recipesField.get(this.getRecipeManager());
            if (!(fieldObjectRef instanceof Map)) {
                LOG.fatal("Obtained 'RecipeManager.recipes' object not instance of Map! Cannot continue");
                throw new IllegalStateException("'RecipeManager.recipes' is not a valid Map implementation");
            }
        }
        catch (NoSuchFieldException e) {
            LOG.fatal("Failed to obtain 'RecipeManager.recipes' field reference! Cannot continue", (Throwable)e);
            throw new IllegalStateException("'RecipeManager.recipes' is not a valid, obtainable field", e);
        }
        catch (IllegalAccessException e) {
            LOG.fatal("Failed to obtain 'RecipeManager.recipes' object reference! Cannot continue", (Throwable)e);
            throw new IllegalStateException("'RecipeManager.recipes' is not obtainable", e);
        }
        return recipesField;
    }

    private Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipesToMap(List<IRecipe<?>> recipes) {
        HashMap newRecipes = Maps.newHashMap();
        recipes.forEach(recipe -> {
            Map map1 = newRecipes.computeIfAbsent(recipe.func_222127_g(), type -> Maps.newHashMap());
            IRecipe irecipe = map1.put(recipe.func_199560_c(), recipe);
            if (irecipe != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + recipe.func_199560_c());
            }
        });
        return newRecipes;
    }

    private void setRecipesField(Field recipesField, Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipes) {
        try {
            recipesField.set(this.getRecipeManager(), ImmutableMap.copyOf(recipes));
        }
        catch (IllegalAccessException e) {
            LOG.fatal("Failed to modify 'RecipeManager.recipes' object reference! Cannot continue", (Throwable)e);
            throw new IllegalStateException("Could not modify 'RecipeManager.recipes' object reference", e);
        }
        Field recipesErroredField = Arrays.stream(RecipeManager.class.getDeclaredFields()).filter(field -> field.getType().equals(Boolean.TYPE)).findFirst().orElse(null);
        if (recipesErroredField != null) {
            try {
                recipesErroredField.setAccessible(true);
                recipesErroredField.setBoolean(this.getRecipeManager(), false);
                LOG.info("Reset the 'RecipeManager.someRecipesErrored' field.");
            }
            catch (IllegalAccessException exception) {
                LOG.error("Reset failed!", (Throwable)exception);
            }
        } else {
            LOG.error("Could not find 'RecipeManager.someRecipesErrored', or any Boolean type fields at all.");
        }
    }

    private RecipeManager getRecipeManager() {
        if (this.recipeManager == null) {
            throw new IllegalStateException("Attempted use of the RecipeManager before construction!");
        }
        return this.recipeManager;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        LOG.debug("onAddReloadListeners() fired! Setting up RecipeManager & self.");
        this.recipeManager = event.getDataPackRegistries().func_240967_e_();
        event.addListener((IFutureReloadListener)this);
    }

    static {
        LOG = ResynthMod.getNewLogger();
    }

    public static interface RecipeProvider {
        @Nullable
        public IRecipe<?>[] get();

        public static FurnaceRecipe newFurnaceRecipe(ResourceLocation resource, String group, double experience, int time, ItemStack output, IItemProvider input) {
            return new FurnaceRecipe(resource, group, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), output, (float)experience, time);
        }

        public static FurnaceRecipe newFurnaceRecipe(String resourcePath, String group, double experience, int time, ItemStack output, IItemProvider input) {
            return RecipeProvider.newFurnaceRecipe(RecipeProvider.rrl(resourcePath), group, experience, time, output, input);
        }

        public static ShapelessRecipe newShapelessRecipe(ResourceLocation resource, String group, ItemStack output, IItemProvider ... input) {
            NonNullList ingredients = NonNullList.func_191196_a();
            for (IItemProvider in : input) {
                ingredients.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{in}));
            }
            return new ShapelessRecipe(resource, group, output, ingredients);
        }

        public static ShapelessRecipe newShapelessRecipe(String resourcePath, String group, ItemStack output, IItemProvider ... input) {
            return RecipeProvider.newShapelessRecipe(RecipeProvider.rrl(resourcePath), group, output, input);
        }

        public static ResourceLocation rrl(String path) {
            return new ResourceLocation("resynth", path);
        }
    }

    private static enum CoreRecipes implements RecipeProvider
    {
        INSTANCE;

        private static final boolean ENSURE_RESOURCE_RECIPES = false;
        private static final IRecipe<?> MINERAL_ROCK_ALT_RECIPE;
        private static final IRecipe<?> CALVINITE_CRYSTAL_ALT_RECIPE;
        private static final IRecipe<?> SYLVANITE_CRYSTAL_ALT_RECIPE;
        private static final IRecipe<?> MINERAL_ROCK_SEEDS_ALT_RECIPE;
        private static final IRecipe<?> CALVINITE_CRYSTAL_SEEDS_ALT_RECIPE;
        private static final boolean ENABLE_RESOURCE_RECIPES;
        private IRecipe<?>[] recipes;

        private void addResourceRecipes(List<IRecipe<?>> recipeContainer) {
            if (!ENABLE_RESOURCE_RECIPES) {
                return;
            }
            recipeContainer.add(MINERAL_ROCK_ALT_RECIPE);
            recipeContainer.add(MINERAL_ROCK_SEEDS_ALT_RECIPE);
            recipeContainer.add(CALVINITE_CRYSTAL_ALT_RECIPE);
            recipeContainer.add(CALVINITE_CRYSTAL_SEEDS_ALT_RECIPE);
            recipeContainer.add(SYLVANITE_CRYSTAL_ALT_RECIPE);
        }

        private IRecipe<?>[] build() {
            ArrayList tempRecipes = new ArrayList();
            this.addResourceRecipes(tempRecipes);
            this.recipes = tempRecipes.toArray(new IRecipe[0]);
            return this.recipes;
        }

        @Override
        public IRecipe<?>[] get() {
            if (this.recipes == null) {
                return this.build();
            }
            return this.recipes;
        }

        static {
            MINERAL_ROCK_ALT_RECIPE = RecipeProvider.newShapelessRecipe("special_mineral_rock", "Resynth's Resources", new ItemStack(ResynthItems.ITEM_MINERAL_ROCK, 6), new IItemProvider[]{Items.field_151042_j, Items.field_151042_j, Items.field_196136_br, Items.field_151137_ax, Items.field_151137_ax, Items.field_151137_ax});
            CALVINITE_CRYSTAL_ALT_RECIPE = RecipeProvider.newShapelessRecipe("special_calvinite_crystal", "Resynth's Resources", new ItemStack(ResynthItems.ITEM_CALVINITE, 2), new IItemProvider[]{Items.field_151128_bU, Items.field_151128_bU, Items.field_196136_br, Items.field_151137_ax, Items.field_151137_ax, Items.field_151137_ax});
            SYLVANITE_CRYSTAL_ALT_RECIPE = RecipeProvider.newShapelessRecipe("special_sylvanite_crystal", "Resynth's Resources", new ItemStack(ResynthItems.ITEM_SYLVANITE, 6), new IItemProvider[]{Items.field_151045_i, Items.field_221828_dx, Items.field_196136_br, Items.field_151137_ax, Items.field_151137_ax, Items.field_151137_ax});
            MINERAL_ROCK_SEEDS_ALT_RECIPE = RecipeProvider.newShapelessRecipe("special_mineral_rock_seeds", "Resynth's Resources", new ItemStack((IItemProvider)ResynthPlants.MINERAL_ROCKS.getSeedsItem(), 1), new IItemProvider[]{Items.field_151042_j, Items.field_151042_j, Items.field_196136_br, Items.field_151137_ax, Items.field_151137_ax, Items.field_151137_ax, Items.field_151166_bC, Items.field_151014_N});
            CALVINITE_CRYSTAL_SEEDS_ALT_RECIPE = RecipeProvider.newShapelessRecipe("special_calvinite_crystal_seeds", "Resynth's Resources", new ItemStack((IItemProvider)ResynthPlants.CALVINITE_CRYSTAL.getSeedsItem(), 1), new IItemProvider[]{Items.field_151128_bU, Items.field_151128_bU, Items.field_196136_br, Items.field_151137_ax, Items.field_151137_ax, Items.field_151137_ax, Items.field_151166_bC, Items.field_151081_bc});
            ENABLE_RESOURCE_RECIPES = ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).enableResourceRecipes();
        }
    }
}

