/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.analytics;

import com.ki11erwolf.resynth.analytics.ResynthAnalytics;
import dmurph.tracking.AnalyticsRequestData;
import java.util.HashMap;
import java.util.Map;

public abstract class Event {
    private static final String RESYNTH_VERSION = "6.1.1";
    private static final String MC_VERSION = "[1.16.5]".replace("[", "").replace("]", "");
    private final AnalyticsRequestData backingEventData = new AnalyticsRequestData();

    Event() {
        ResynthAnalytics.setEventHost(this.backingEventData);
    }

    protected abstract String getName();

    protected Map<String, String> getProperties() {
        return new HashMap<String, String>();
    }

    protected String getAction() {
        return this.getName() + Event.propertiesToString(this.getProperties());
    }

    protected String getCategory() {
        Map<String, String> properties = this.getProperties();
        properties.put("version", RESYNTH_VERSION);
        properties.put("minecraft_version", MC_VERSION);
        return this.getName() + Event.propertiesToString(properties);
    }

    protected String getLabel() {
        return String.format("Event[resynth=%s, minecraft=%s]", RESYNTH_VERSION, MC_VERSION);
    }

    protected static String propertiesToString(Map<String, String> properties) {
        if (properties.size() == 0) {
            return "";
        }
        StringBuilder props = new StringBuilder("[");
        for (Map.Entry<String, String> propEntry : properties.entrySet()) {
            props.append(propEntry.getKey()).append("=").append(propEntry.getValue()).append(",");
        }
        return props.substring(0, props.length() - 1) + "]";
    }

    protected AnalyticsRequestData getEventData() {
        this.backingEventData.setEventAction(this.getAction());
        this.backingEventData.setEventCategory(this.getCategory());
        this.backingEventData.setEventLabel(this.getLabel());
        return this.backingEventData;
    }

    public String toString() {
        return String.format("Resynth.Event[name=%s, properties=%s, action=%s, category=%s, label=%s]", this.getName(), Event.propertiesToString(this.getProperties()), this.getAction(), this.getCategory(), this.getLabel());
    }
}

