/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.analytics;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.analytics.ConnectEvent;
import com.ki11erwolf.resynth.analytics.Event;
import com.ki11erwolf.resynth.analytics.NewUserEvent;
import com.ki11erwolf.resynth.analytics.SSLHelper;
import com.ki11erwolf.resynth.analytics.SeedPodEvent;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.config.categories.SeedPodConfig;
import com.ki11erwolf.resynth.integration.SupportedMods;
import dmurph.tracking.AnalyticsConfigData;
import dmurph.tracking.AnalyticsRequestData;
import dmurph.tracking.JGoogleAnalyticsTracker;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public final class ResynthAnalytics {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static final boolean ENABLED = ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).isAnalyticsEnabled();
    private static final File RESYNTH_USER_FILE = new File(System.getProperty("user.home") + "/AppData/Roaming/.minecraft/resynth-user");
    private static final String CODE = "UA-127648959-1";
    private static final String RESYNTH_DOMAIN = "https://resynth-minecraft-mod.github.io";
    private static final String IDENTIFIER_PAGE = "/jar";
    private static final String TITLE = "Resynth - Jar";
    private static final JGoogleAnalyticsTracker ANALYTICS;

    private ResynthAnalytics() {
    }

    public static void init() {
        ResynthAnalytics.send(new ConnectEvent());
        ResynthAnalytics.send(new SeedPodEvent(ResynthConfig.GENERAL_CONFIG.getCategory(SeedPodConfig.class).areDropsEnabled()));
        SupportedMods.sendModIntegrationEvents();
        if (!RESYNTH_USER_FILE.exists()) {
            ResynthAnalytics.send(new NewUserEvent());
            try {
                boolean create = RESYNTH_USER_FILE.createNewFile();
                if (!create) {
                    LOG.error("Failed to create Resynth NU file");
                }
            }
            catch (IOException e) {
                LOG.error("Failed to create Resynth NU file", (Throwable)e);
            }
        }
    }

    public static void send(Event e) {
        if (!ENABLED || ANALYTICS == null) {
            LOG.info(String.format("Analytics disabled! Event (%s) prevented from sending.", e.toString()));
            SSLHelper.enableSSL();
            return;
        }
        SSLHelper.disableSSL();
        LOG.info("Sending analytics event: " + e.toString());
        ANALYTICS.makeCustomRequest(e.getEventData());
        SSLHelper.enableSSL();
    }

    static void setEventHost(AnalyticsRequestData eventData) {
        eventData.setHostName(RESYNTH_DOMAIN);
        eventData.setPageURL(IDENTIFIER_PAGE);
        eventData.setPageTitle(TITLE);
    }

    static {
        RESYNTH_USER_FILE.getParentFile().mkdir();
        RESYNTH_USER_FILE.getParentFile().mkdirs();
        SSLHelper.disableSSL();
        if (ENABLED) {
            LOG.info("Analytics has been enabled!");
            ANALYTICS = new JGoogleAnalyticsTracker(new AnalyticsConfigData(CODE), JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
        } else {
            LOG.info("Analytics has been enabled!");
            ANALYTICS = null;
        }
    }
}

