/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.analytics;

import com.ki11erwolf.resynth.ResynthMod;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.Logger;

class SSLHelper {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static boolean isSSLDisabled = false;
    private static SSLSocketFactory defaultSocketFactory;
    private static HostnameVerifier defaultHostnameVerifier;

    private SSLHelper() {
    }

    public static void disableSSL() {
        if (!isSSLDisabled) {
            LOG.debug("Disabling SSL...");
            try {
                defaultSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
                defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HostnameVerifier allHostsValid = (hostname, session) -> true;
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                ResynthMod.getNewLogger().error("Failed to disable SSL", (Throwable)e);
            }
            isSSLDisabled = true;
        }
    }

    public static void enableSSL() {
        if (defaultSocketFactory != null && defaultHostnameVerifier != null) {
            LOG.debug("Enabling SSL...");
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
            isSSLDisabled = false;
        } else {
            LOG.warn(String.format("Call to 'SSLHelper.enableSSL()' failed! Additional Information: [SocketFactory=%s, HostnameVerifier=%s, isSSLDisabled=%s]", defaultSocketFactory, defaultHostnameVerifier, isSSLDisabled));
        }
    }
}

