/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.block;

import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.util.ExpandingTooltip;
import com.ki11erwolf.resynth.util.Tooltip;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ToolType;

public class BlockEnhancer
extends ResynthBlock<BlockEnhancer> {
    private static final String BLOCK_NAME = "enhancer";
    private final float increase;
    private final int stageIncrease;

    BlockEnhancer(String name, float increase, int stageIncrease) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f), name + "_" + BLOCK_NAME);
        this.increase = increase;
        this.stageIncrease = stageIncrease;
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        new ExpandingTooltip().setCtrlForDescription(tooltips -> Tooltip.addBlankLine(tooltips).addAll(Arrays.asList(Tooltip.formatLineFeeds(BlockEnhancer.getDescriptiveTooltip(this.getRegistryName() == null ? "" : this.getRegistryName().func_110623_a(), Float.valueOf(this.increase)), TextFormatting.DARK_GRAY)))).write(tooltip).add(Tooltip.newBlankLine());
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public float getIncrease() {
        return this.increase;
    }

    int getStageIncrease() {
        return this.stageIncrease;
    }
}

