/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.block;

import com.ki11erwolf.resynth.block.BlockEnhancer;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.block.tileEntity.ResynthTileEntity;
import com.ki11erwolf.resynth.block.tileEntity.TileEntityMineralSoil;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.MineralSoilConfig;
import com.ki11erwolf.resynth.item.ItemMineralHoe;
import com.ki11erwolf.resynth.item.ResynthItems;
import com.ki11erwolf.resynth.util.MinecraftUtil;
import java.util.List;
import java.util.Map;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockMineralSoil
extends ResynthTileEntity<TileEntityMineralSoil>
implements IComponentProvider,
IServerDataProvider<TileEntity>,
IProbeInfoAccessor,
ItemMineralHoe.MineralHoeInfoProvider {
    private static final MineralSoilConfig CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(MineralSoilConfig.class);
    private static final IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)0, (int)6);
    private static final VoxelShape MINERAL_SOIL_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    BlockMineralSoil(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151578_c).func_200943_b(2.0f).func_200947_a(SoundType.field_185849_b), name);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return MINERAL_SOIL_SHAPE;
    }

    private void updateState(float mineralContent, World world, BlockState state, BlockPos pos) {
        if ((double)mineralContent > 49.9) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(4 + BlockMineralSoil.getStageIncrease(world, pos))));
        } else if ((double)mineralContent > 39.9) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(3)));
        } else if ((double)mineralContent > 29.9) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(2)));
        } else if ((double)mineralContent > 19.9) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(1)));
        } else {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)STAGE, (Comparable)Integer.valueOf(0)));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STAGE});
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this);
    }

    public void func_220062_a(BlockState state, ServerWorld world, BlockPos pos, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        MinecraftUtil.spawnItemInWorld(ResynthItems.ITEM_MINERAL_CRYSTAL, (World)world, pos);
        MinecraftUtil.spawnItemStackInWorld(new ItemStack((IItemProvider)Blocks.field_150346_d), (World)world, pos);
        super.func_220062_a(state, world, pos, stack);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (!(tileentity instanceof TileEntityMineralSoil)) {
                super.func_196243_a(state, world, pos, newState, isMoving);
            }
            assert (tileentity != null);
            assert (tileentity instanceof TileEntityMineralSoil);
            float content = ((TileEntityMineralSoil)tileentity).getMineralPercentage();
            int rocks = (int)(((double)content - CONFIG.getStartingMineralContent()) / CONFIG.getMineralRockWorth());
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(ResynthItems.ITEM_MINERAL_ROCK, rocks));
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Override
    public Class<TileEntityMineralSoil> getTileEntityClass() {
        return TileEntityMineralSoil.class;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityMineralSoil();
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntityMineralSoil tile = (TileEntityMineralSoil)((Object)this.getTileEntity((IBlockReader)world, data.getPos()));
        float mineralContent = tile.getMineralPercentage();
        float contentIncrease = BlockMineralSoil.getMineralContentIncrease(world, data.getPos());
        float max = 50.0f;
        float totalMineralContent = mineralContent + (mineralContent >= max ? contentIncrease : 0.0f);
        probeInfo.text((ITextComponent)new StringTextComponent(""));
        IProbeInfo child = probeInfo.horizontal();
        child.progress((int)mineralContent, (int)max);
        if (contentIncrease > 0.0f) {
            child.text((ITextComponent)new StringTextComponent(TextFormatting.RED.toString() + (mineralContent >= max ? "" : TextFormatting.STRIKETHROUGH) + "+" + contentIncrease + "%"));
        }
        probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.BOLD.toString() + TextFormatting.BLUE.toString() + "C: " + totalMineralContent + "%"));
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        tooltip.add((ITextComponent)new StringTextComponent(""));
        tooltip.add((ITextComponent)new StringTextComponent(BlockMineralSoil.getMineralContentMessage(accessor.getServerData().func_74760_g("mineralPercentage"), accessor.getServerData().func_74760_g("mineralIncrease"))));
        tooltip.add((ITextComponent)new StringTextComponent(""));
    }

    @Override
    public void appendServerData(CompoundNBT clientServerNBT, ServerPlayerEntity serverPlayerEntity, World world, TileEntity tileEntity) {
        if (!(tileEntity instanceof TileEntityMineralSoil)) {
            return;
        }
        float mineralContent = ((TileEntityMineralSoil)tileEntity).getMineralPercentage();
        clientServerNBT.func_74776_a("mineralPercentage", mineralContent);
        if ((double)mineralContent >= 50.0) {
            clientServerNBT.func_74776_a("mineralIncrease", BlockMineralSoil.getMineralContentIncrease(world, tileEntity.func_174877_v()));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        float increase;
        ItemStack usedItem = player.func_184586_b(hand);
        TileEntityMineralSoil entityMineralSoil = (TileEntityMineralSoil)((Object)this.getTileEntity((IBlockReader)world, pos));
        float mineralContent = entityMineralSoil.getMineralPercentage();
        if (mineralContent >= 50.0f) {
            return ActionResultType.FAIL;
        }
        if (usedItem.func_77973_b() == ResynthItems.ITEM_MINERAL_ROCK) {
            increase = (float)CONFIG.getMineralRockWorth();
        } else if (usedItem.func_77973_b() == ResynthItems.ITEM_DENSE_MINERAL_ROCK) {
            increase = (float)CONFIG.getMineralRockWorth() * 9.0f;
        } else {
            return ActionResultType.FAIL;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_184812_l_()) {
            usedItem.func_190918_g(1);
        }
        entityMineralSoil.increaseMineralPercentage(increase);
        this.updateState(entityMineralSoil.getMineralPercentage(), world, state, pos);
        if (CONFIG.isChatMessageEnabled()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"misc.resynth.mineral_content", (Object[])new Object[]{Float.valueOf(entityMineralSoil.getMineralPercentage())}) + "%"), player.func_110124_au());
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.updateState(((TileEntityMineralSoil)((Object)this.getTileEntity((IBlockReader)worldIn, pos))).getMineralPercentage(), worldIn, state, pos);
    }

    private static int getStageIncrease(World world, BlockPos pos) {
        BlockState enhancer = world.func_180495_p(pos.func_177977_b());
        if (enhancer.func_177230_c() instanceof BlockEnhancer) {
            return ((BlockEnhancer)enhancer.func_177230_c()).getStageIncrease();
        }
        return 0;
    }

    private static float getMineralContentIncrease(World world, BlockPos pos) {
        BlockState enhancer = world.func_180495_p(pos.func_177977_b());
        if (enhancer.func_177230_c() instanceof BlockEnhancer) {
            return ((BlockEnhancer)enhancer.func_177230_c()).getIncrease();
        }
        return 0.0f;
    }

    private static String getMineralContentMessage(float mineralPercentage, float increase) {
        return TextFormatting.AQUA + I18n.func_135052_a((String)"misc.resynth.mineral_content", (Object[])new Object[]{TextFormatting.GOLD + String.valueOf(mineralPercentage + increase)});
    }

    @Override
    public boolean provideHoeInformation(Map<String, Object[]> information, BlockState state, World world, BlockPos pos) {
        information.put("soil_info_header", new Object[]{TextFormatting.GRAY, TextFormatting.BLUE, TextFormatting.GRAY});
        float mineralConcentration = ((TileEntityMineralSoil)((Object)this.getTileEntity((IBlockReader)world, pos))).getMineralPercentage();
        float enhancedConcentration = BlockMineralSoil.getMineralContentIncrease(world, pos);
        float finalConcentration = mineralConcentration + ((double)mineralConcentration >= 50.0 ? enhancedConcentration : 0.0f);
        information.put("soil_mineral_concentration", new Object[]{TextFormatting.AQUA, TextFormatting.GOLD, Float.valueOf(finalConcentration), TextFormatting.GOLD, TextFormatting.DARK_AQUA, Float.valueOf(mineralConcentration), TextFormatting.GREEN.toString() + ((double)mineralConcentration < 50.0 ? TextFormatting.STRIKETHROUGH : ""), Float.valueOf(enhancedConcentration), TextFormatting.GOLD});
        ResourceLocation enhancer = world.func_180495_p(pos.func_177977_b()).func_177230_c().getRegistryName();
        String enhancerKey = "$no_enhancer";
        String color = TextFormatting.WHITE.toString();
        if (enhancer != null) {
            if (enhancer.equals((Object)ResynthBlocks.BLOCK_CALVINITE_ENHANCER.getRegistryName())) {
                enhancerKey = "$calvinite_enhancer";
                color = TextFormatting.LIGHT_PURPLE.toString();
            }
            if (enhancer.equals((Object)ResynthBlocks.BLOCK_SYLVANITE_ENHANCER.getRegistryName())) {
                enhancerKey = "$sylvanite_enhancer";
                color = TextFormatting.YELLOW.toString();
            }
            if ((double)mineralConcentration < 50.0) {
                color = color + TextFormatting.STRIKETHROUGH;
            }
        }
        information.put("soil_enhancer", new Object[]{TextFormatting.LIGHT_PURPLE, color, enhancerKey, TextFormatting.GOLD, color, Float.valueOf(enhancedConcentration), TextFormatting.GOLD});
        boolean hopperAutoHarvest = world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150438_bZ || world.func_180495_p(pos.func_177977_b().func_177977_b()).func_177230_c() == Blocks.field_150438_bZ;
        information.put("hopper_auto_harvesting", new Object[]{TextFormatting.BLUE, hopperAutoHarvest ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED, hopperAutoHarvest ? "$true" : "$false"});
        information.put("footer", new Object[]{TextFormatting.GRAY});
        return true;
    }
}

