/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.block;

import com.ki11erwolf.resynth.ResynthRecipes;
import com.ki11erwolf.resynth.ResynthTabs;
import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.util.ExpandingTooltip;
import com.ki11erwolf.resynth.util.Tooltip;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;

public class BrittleBlock<B extends Block>
extends ResynthBlock<BrittleBlock<B>> {
    public static final float DEFAULT_EXPLOSION_RESISTANCE = 6.0f;
    public static final float MINIMUM_EXPLOSION_RESISTANCE = 1.0f;
    public static final float MAXIMUM_EXPLOSION_RESISTANCE = 12.0f;
    protected static final String PREFIX = "brittle";
    private final B block;

    public BrittleBlock(B of) {
        this(of, 6.0f);
    }

    public BrittleBlock(B of, float resistance) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)Objects.requireNonNull(of))).lootFrom(() -> of).func_200948_a(of.func_176223_P().func_185887_b(null, null), Math.max(1.0f, Math.min(resistance, 12.0f))), new Item.Properties().func_200916_a(ResynthTabs.TAB_RESYNTH), "brittle_" + Objects.requireNonNull(of.getRegistryName()).func_110623_a());
        this.block = of;
    }

    public float func_149638_a() {
        float resistance = this.field_235689_au_;
        return Math.max(1.0f, Math.min(resistance, 12.0f));
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String originalName = TextFormatting.GRAY + this.block.func_235333_g_().getString() + TextFormatting.DARK_GRAY;
        new ExpandingTooltip().setCtrlForDescription(tooltips -> Tooltip.addBlankLine(tooltips).addAll(Arrays.asList(Tooltip.formatLineFeeds(BrittleBlock.getDescriptiveTooltip("brittle_block", originalName), TextFormatting.DARK_GRAY)))).write(tooltip).add(Tooltip.newBlankLine());
    }

    @Override
    public ResynthBlock<BrittleBlock<B>> queueRegistration() {
        BrittleBlockRecipes.INSTANCE.addBrittleBlockRecipe(this);
        return super.queueRegistration();
    }

    public final B of() {
        return this.block;
    }

    public static enum BrittleBlockRecipes implements ResynthRecipes.RecipeProvider
    {
        INSTANCE;

        private List<BrittleBlock<?>> brittleBlocks = new ArrayList();
        private List<IRecipe<?>> recipes;

        void addBrittleBlockRecipe(BrittleBlock<?> block) {
            this.brittleBlocks.add(block);
        }

        private void createRecipes() {
            this.recipes = new ArrayList();
            for (BrittleBlock<?> block : this.brittleBlocks) {
                this.recipes.add((IRecipe<?>)ResynthRecipes.RecipeProvider.newShapelessRecipe(Objects.requireNonNull(block.getRegistryName()).func_110623_a() + "_to_" + Objects.requireNonNull(block.of().getRegistryName()).func_110623_a(), "brittle_block_recipes", new ItemStack(block), new IItemProvider[]{block.of()}));
                this.recipes.add((IRecipe<?>)ResynthRecipes.RecipeProvider.newShapelessRecipe(Objects.requireNonNull(block.of().getRegistryName()).func_110623_a() + "_to_" + Objects.requireNonNull(block.getRegistryName()).func_110623_a(), "brittle_block_recipes", new ItemStack(block.of()), new IItemProvider[]{block}));
            }
            this.brittleBlocks = null;
        }

        @Override
        public IRecipe<?>[] get() {
            if (this.recipes == null) {
                this.createRecipes();
            }
            return this.recipes.toArray(new IRecipe[0]);
        }
    }
}

