/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config;

import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.ConfigValue;
import java.util.Objects;

public class DoubleConfigValue
implements ConfigValue {
    private final String uniqueName;
    private final String comment;
    private final double defaultValue;
    private final double min;
    private final double max;
    private double value;

    public DoubleConfigValue(String uniqueName, String comment, double defaultValue, double min, double max, ConfigCategory category) {
        this.uniqueName = Objects.requireNonNull(uniqueName).replace(' ', '-');
        this.comment = Objects.requireNonNull(comment);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        category.registerConfigValue(this);
    }

    public DoubleConfigValue(String uniqueName, String comment, double defaultValue, ConfigCategory category) {
        this(uniqueName, comment, defaultValue, 0.0, 0.0, category);
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getComment() {
        return this.comment + (this.min == 0.0 && this.max == 0.0 ? "\n(type=double, min=4.9E-324, max=1.7976931348623157E308, default=" + this.defaultValue + ")" : "\n(type=double, min=" + this.min + ", max=" + this.max + ", default=" + this.defaultValue + ")");
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(Object value) {
        try {
            this.value = Double.parseDouble(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            this.value = this.defaultValue;
        }
        if (this.max == 0.0 && this.min == 0.0) {
            return;
        }
        if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
    }

    @Override
    public Object get() {
        return this.getValue();
    }
}

