/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.DoubleConfigValue;
import com.ki11erwolf.resynth.config.IntegerConfigValue;
import com.ki11erwolf.resynth.plant.set.properties.AbstractBiochemicalProperties;
import java.util.Objects;

public class BiochemicalPropertiesConfig
extends ConfigCategory
implements AbstractBiochemicalProperties {
    private static final String PREFIX = "plant-set-";
    private final DoubleConfigValue chanceToGrow;
    private final BooleanConfigValue canUseBonemeal;
    private final IntegerConfigValue numberOfProduceDrops;
    private final DoubleConfigValue seedSpawnChanceFromMob;
    private final DoubleConfigValue seedSpawnChanceFromBulb;
    private final BooleanConfigValue useConfigGrowthChanceValue;
    private final BooleanConfigValue useConfigSeedChanceValues;

    public BiochemicalPropertiesConfig(String plantSetName, AbstractBiochemicalProperties defaultProperties) {
        super(PREFIX + Objects.requireNonNull(plantSetName));
        this.chanceToGrow = new DoubleConfigValue("chance-to-grow", "The chance (percentage) this plant type will grow on a random tick.\nIncrease this number to increase the growth rate of the plant,\ndecrease it to decrease the growth rate of the plant.\nYOU MUST SET 'use-configuration-values-for-growth' TO 'true' TO USE THIS.", defaultProperties.growthProbability(), 0.0, 100.0, this);
        this.canUseBonemeal = new BooleanConfigValue("enable-bonemeal", "Set this to true to allow using bonemeal on this specific plant type.", defaultProperties.bonemealGrowth(), this);
        this.numberOfProduceDrops = new IntegerConfigValue("number-of-produce-drops", "The number of produce item drops this plant type will drop when harvested/fully grownand broken.", defaultProperties.plantYield(), 1, 64, this);
        this.seedSpawnChanceFromMob = new DoubleConfigValue("seed-spawn-chance-from-mob", "The chance (percentage) that this plant types seed will spawn\nwhen the mob that normally drops the final resource is killed.\nSet this to 0 to prevent the seeds from spawning when the mob is killed.\nYOU MUST SET 'use-configuration-values-for-seed-drops' TO 'true' TO USE THIS.", defaultProperties.seedSpawnChanceFromMob(), 0.0, 100.0, this);
        this.seedSpawnChanceFromBulb = new DoubleConfigValue("seed-spawn-chance-from-bulb", "The chance (percentage) that this plant types seed will spawn\nwhen the plants produce (bulb) is smashed.\nSet this to 0 to prevent the seeds from spawning when the bulb is smashed.\nYOU MUST SET 'use-configuration-values-for-seed-drops' TO 'true' TO USE THIS.", defaultProperties.seedSpawnChanceFromBulb(), 0.0, 100.0, this);
        this.useConfigGrowthChanceValue = new BooleanConfigValue("use-configuration-values-for-growth", "Prevents the configuration value for 'chance-to-grow' from being used\nforcing the default value to be used instead, when this is 'false'.\nYou must set this to 'true' before the 'chance-to-grow' config value will work!", false, this);
        this.useConfigSeedChanceValues = new BooleanConfigValue("use-configuration-values-for-seed-drops", "Prevents the configuration values for 'seed-spawn-chance-*' from being used\nforcing the default value to be used instead, when this is 'false'.\nYou must set this to 'true' before the 'seed-spawn-chance-*' config values will work!", false, this);
    }

    @Override
    public int plantYield() {
        return this.numberOfProduceDrops.getValue();
    }

    @Override
    public float seedSpawnChanceFromMob() {
        if (!this.useConfigSeedChanceValues.getValue()) {
            return Float.parseFloat(this.seedSpawnChanceFromMob.getDefaultValue().toString());
        }
        return (float)this.seedSpawnChanceFromMob.getValue();
    }

    @Override
    public float seedSpawnChanceFromBulb() {
        if (!this.useConfigSeedChanceValues.getValue()) {
            return Float.parseFloat(this.seedSpawnChanceFromBulb.getDefaultValue().toString());
        }
        return (float)this.seedSpawnChanceFromBulb.getValue();
    }

    @Override
    public boolean bonemealGrowth() {
        return this.canUseBonemeal.getValue();
    }

    @Override
    public float growthProbability() {
        if (!this.useConfigGrowthChanceValue.getValue()) {
            return Float.parseFloat(this.chanceToGrow.getDefaultValue().toString());
        }
        return (float)this.chanceToGrow.getValue();
    }
}

