/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.DoubleConfigValue;
import com.ki11erwolf.resynth.config.IntegerConfigValue;
import com.ki11erwolf.resynth.plant.set.properties.AbstractCrystallineProperties;

public class CrystallinePropertiesConfig
extends ConfigCategory
implements AbstractCrystallineProperties {
    private static final String PREFIX = "plant-set-";
    private final BooleanConfigValue canUseBonemeal;
    private final DoubleConfigValue chanceToGrow;
    private final IntegerConfigValue numberOfProduceDrops;
    private final DoubleConfigValue seedSpawnChanceFromOre;
    private final DoubleConfigValue seedSpawnChanceFromShard;
    private final BooleanConfigValue useConfigGrowthChanceValue;
    private final BooleanConfigValue useConfigSeedChanceValues;
    private final IntegerConfigValue resourcesPerSeedsConfig;

    public CrystallinePropertiesConfig(String plantSetName, AbstractCrystallineProperties defaultProperties) {
        super(PREFIX + plantSetName);
        this.canUseBonemeal = new BooleanConfigValue("enable-bonemeal", "Set this to true to allow using bonemeal on this specific plant type.", defaultProperties.bonemealGrowth(), this);
        this.chanceToGrow = new DoubleConfigValue("chance-to-grow", "The chance (percentage) this plant type will grow on a random tick.\nIncrease this number to increase the growth rate of the plant,\ndecrease it to decrease the growth rate of the plant.\nYOU MUST SET 'use-configuration-values-for-growth' TO 'true' TO USE THIS.", defaultProperties.growthProbability(), 0.0, 100.0, this);
        this.numberOfProduceDrops = new IntegerConfigValue("number-of-produce-drops", "The number of produce item drops this plant type will drop when fully grown\nand broken.", defaultProperties.plantYield(), 1, 64, this);
        this.seedSpawnChanceFromOre = new DoubleConfigValue("seed-spawn-chance-from-ore", "The chance (percentage) that this plant types seed will spawn\nwhen mining the growable resources ore block. Set this to 0 to\nprevent the seeds from spawning when mining the ore blocks.\nYOU MUST SET 'use-configuration-values-for-seed-drops' TO 'true' TO USE THIS.", defaultProperties.seedSpawnChanceFromOre(), 0.0, 100.0, this);
        this.seedSpawnChanceFromShard = new DoubleConfigValue("seed-spawn-chance-from-shard", "The chance (percentage) that this plant types seed will spawn\nwhen the plants produce (shard) is left in water to despawn.\nSet this to 0 to prevent seed spawning from shards.\nYOU MUST SET 'use-configuration-values-for-seed-drops' TO 'true' TO USE THIS.", defaultProperties.seedSpawnChanceFromShard(), 0.0, 100.0, this);
        this.useConfigGrowthChanceValue = new BooleanConfigValue("use-configuration-values-for-growth", "Prevents the configuration value for 'chance-to-grow' from being used\nforcing the default value to be used instead, when this is 'false'.\nYou must set this to 'true' before the 'chance-to-grow' config value will work!", false, this);
        this.useConfigSeedChanceValues = new BooleanConfigValue("use-configuration-values-for-seed-drops", "Prevents the configuration values for 'seed-spawn-chance-*' from being used\nforcing the default value to be used instead, when this is 'false'.\nYou must set this to 'true' before the 'seed-spawn-chance-*' config values will work!", false, this);
        this.resourcesPerSeedsConfig = new IntegerConfigValue("number-of-resources-crafted-from-seeds", "The amount of resource items, that this plant set grows, that will be crafted when\nplacing this plants seeds in a crafting table. A value of 0 (zero) will disable this\nfeature for the particular plant and plant set. ", defaultProperties.seedCraftingYield(), 0, 64, this);
    }

    @Override
    public boolean bonemealGrowth() {
        return this.canUseBonemeal.getValue();
    }

    @Override
    public float growthProbability() {
        if (!this.useConfigGrowthChanceValue.getValue()) {
            return Float.parseFloat(this.chanceToGrow.getDefaultValue().toString());
        }
        return (float)this.chanceToGrow.getValue();
    }

    @Override
    public int plantYield() {
        return this.numberOfProduceDrops.getValue();
    }

    @Override
    public float seedSpawnChanceFromOre() {
        if (!this.useConfigSeedChanceValues.getValue()) {
            return Float.parseFloat(this.seedSpawnChanceFromOre.getDefaultValue().toString());
        }
        return (float)this.seedSpawnChanceFromOre.getValue();
    }

    @Override
    public float seedSpawnChanceFromShard() {
        if (!this.useConfigSeedChanceValues.getValue()) {
            return Float.parseFloat(this.seedSpawnChanceFromShard.getDefaultValue().toString());
        }
        return (float)this.seedSpawnChanceFromShard.getValue();
    }

    @Override
    public int seedCraftingYield() {
        return this.resourcesPerSeedsConfig.getValue();
    }
}

