/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.IntegerConfigValue;

public class GenConfig
extends ConfigCategory {
    private final BooleanConfigValue generate;
    private final IntegerConfigValue size;
    private final IntegerConfigValue rarity;
    private final IntegerConfigValue minimumHeight;
    private final IntegerConfigValue maximumHeight;

    GenConfig(String configName, boolean generate, int size, int rarity, int minimumHeight, int maximumHeight) {
        super(configName + ".ore-generation");
        this.generate = new BooleanConfigValue("generate", "Allows enabling or disabling generating the ore block in the world.\nSet this to false to prevent the ore block from spawning in the world", generate, this);
        this.size = new IntegerConfigValue("vein-size", "The average size of the ore veins. Set this number\nhigher to increase the amount of ore blocks in an ore vein.", size, 1, 64, this);
        this.rarity = new IntegerConfigValue("vein-rarity", "The average number/frequency of ore veins in a chunk.\nSet this number higher to increase the number of ore veins.", rarity, 1, 64, this);
        this.minimumHeight = new IntegerConfigValue("minimum-vein-height", "The minimum height (Y-level) that the ore blocks will generate.", minimumHeight, 1, 254, this);
        this.maximumHeight = new IntegerConfigValue("maximum-vein-height", "The maximum height (Y-level) that the ore blocks will generate", maximumHeight, 1, 255, this);
    }

    public boolean shouldGenerate() {
        return this.generate.getValue();
    }

    public int getSize() {
        return this.size.getValue();
    }

    public int getRarity() {
        return this.rarity.getValue();
    }

    public int getMinimumHeight() {
        return this.minimumHeight.getValue();
    }

    public int getMaximumHeight() {
        return this.maximumHeight.getValue();
    }
}

