/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.DoubleConfigValue;
import com.ki11erwolf.resynth.config.IntegerConfigValue;

public class GeneralConfig
extends ConfigCategory {
    private final BooleanConfigValue enableAnalytics = new BooleanConfigValue("enable analytics", "Enables or disables all the analytical features of the mod.\nIncluding usage and error reports (all sent reports are anonymous).\nFalse to disable, true to enable.", true, this);
    private final BooleanConfigValue enableDebugHelp = new BooleanConfigValue("enable debug help", "Enables features related to debugging and development.\nIt's unlikely you'd want to enable this.", false, this);
    private final BooleanConfigValue enableHelpTooltips = new BooleanConfigValue("enable descriptive tooltips", "Set to true to show detailed and descriptive tooltips on all Resynth blocks & items.", true, this);
    private final BooleanConfigValue enableHopperAutoFarming = new BooleanConfigValue("allow hopper auto-farming", "Allows auto-farming using hoppers when true, where plants will drop their\nproduce in a hopper underneath the plant when fully grown, starting the\ngrowth cycle over.", true, this);
    private final IntegerConfigValue tooltipCharacterLimit = new IntegerConfigValue("tooltip-character-limit", "The maximum amount of characters allowed on a single line in an item or block tooltip.", 60, 20, 100, this);
    private final BooleanConfigValue enableBrightnessBasedGrowth = new BooleanConfigValue("is-growth-affected-by-light", "Determines if the lighting in the world affects the growth rates and chances of planted crops.\nWhen 'true', the growth rates of plants change slightly based on the amount of ambient light\nand brightness on the plant. Low to moderate amounts of light negatively affect growth, while\nvery bright light  positively affects growth.", true, this);
    private final IntegerConfigValue lightLevelZeroPoint = new IntegerConfigValue("light-level-zero-point", "The light level at which the growth multiplier is 0 (zero), making any lower light levels decrease the\nmultiplier while any higher light levels increase the multiplier. Said in layman's terms: sets the point\nwhere light levels change from decreasing the growth multiplier to increasing the growth multiplier.", 11, 9, 13, this);
    private final DoubleConfigValue lightLevelWorth = new DoubleConfigValue("worth-of-light-level-as-growth-multiplier", "The percentage (in decimal form: 0.04 = 4%) each level of light (above or below the zero point) is worth.\nEach level of light will change the multiplier by this value - minimum. So, at a worth of 0.04, 3 levels\nabove the zero point will add +0.12 to the multiplier, increasing growth by 12%. This works the same way in\nthe reverse direction.", 0.04, 0.001, 0.1, this);
    private final DoubleConfigValue lightLevelInterest = new DoubleConfigValue("interest-increase-on-worth-per-level", "The amount of interest added to the worth of a light level, for each light level above or below the zero\npoint. Put more simply, it's the amount each additional light level adds to the worth of a light level. \nThis value controls the exponential growth of the cost per light level.", 0.01, -1.0, 1.0, this);
    private final BooleanConfigValue enableResourceRecipes = new BooleanConfigValue("enable-core-resource-recipes", "Allows enabling (or disabling) the addition of various crafting recipes that can be used to craft Resynth's core resources:\nMineral Rocks, Calvinite Crystals, Sylvanite Crystals, ect. These resources are NOT normally craftable, instead, they need\nto mined or otherwise obtained from the world.\nEnable this config option if the ores/resources are not generating naturally, or if the resources cannot otherwise be obtained.", false, this);
    private final BooleanConfigValue enableCraftingCrystallineSeeds = new BooleanConfigValue("enable-crafting-crystalline-seeds", "All Crystalline type plants and plant sets offer the ability to directly craft\nthe resource grown by this plant by placing the plants seeds in a crafting table.\nThis option is available if you wish to be able turn seeds mined from ores into the\nresource that would normally drop, without having to grow it, or for any other reason.\nSet this option to 'true' to enable the functionality.", false, this);

    public GeneralConfig() {
        super("general-resynth-config");
    }

    public boolean isAnalyticsEnabled() {
        return this.enableAnalytics.getValue();
    }

    public boolean isDevHelpEnabled() {
        return this.enableDebugHelp.getValue();
    }

    public boolean areTooltipsEnabled() {
        return this.enableHelpTooltips.getValue();
    }

    public boolean isHopperAutoFarmingEnabled() {
        return this.enableHopperAutoFarming.getValue();
    }

    public int getTooltipCharacterLimit() {
        return this.tooltipCharacterLimit.getValue();
    }

    public boolean isGrowthLightDependent() {
        return this.enableBrightnessBasedGrowth.getValue();
    }

    public int getLightLevelZeroPoint() {
        return this.lightLevelZeroPoint.getValue();
    }

    public double getWorthPerLightLevel() {
        return this.lightLevelWorth.getValue();
    }

    public double getInterestPerLightLevel() {
        return this.lightLevelInterest.getValue();
    }

    public boolean enableResourceRecipes() {
        return this.enableResourceRecipes.getValue();
    }
}

