/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.DoubleConfigValue;
import com.ki11erwolf.resynth.plant.set.properties.AbstractMetallicProperties;
import com.ki11erwolf.resynth.plant.set.properties.MetallicProperties;

public class MetallicPropertiesConfig
extends ConfigCategory
implements AbstractMetallicProperties {
    private static final String PREFIX = "plant-set-";
    private final BooleanConfigValue canUseBonemeal;
    private final DoubleConfigValue chanceToGrow;
    private final DoubleConfigValue seedSpawnChanceFromOre;
    private final DoubleConfigValue seedSpawnChanceFromOrganicOre;
    private final BooleanConfigValue useConfigGrowthChanceValue;
    private final BooleanConfigValue useConfigSeedChanceValues;

    public MetallicPropertiesConfig(String plantSetName, MetallicProperties defaultProperties) {
        super(PREFIX + plantSetName);
        this.canUseBonemeal = new BooleanConfigValue("enable-bonemeal", "Set this to true to allow using bonemeal on this specific plant type.", defaultProperties.bonemealGrowth(), this);
        this.chanceToGrow = new DoubleConfigValue("chance-to-grow", "The chance (percentage) this plant type will grow on a random tick.\nIncrease this number to increase the growth rate of the plant,\ndecrease it to decrease the growth rate of the plant.\nYOU MUST SET 'use-configuration-values-for-growth' TO 'true' TO USE THIS.", defaultProperties.growthProbability(), 0.0, 100.0, this);
        this.seedSpawnChanceFromOre = new DoubleConfigValue("seed-spawn-chance-from-ore", "The chance (percentage) that this plant types seed will spawn\nwhen the final products ore block is blown up with TNT.\nSet this to 0 to prevent the seeds from spawning when blowing up the ore blocks.\nYOU MUST SET 'use-configuration-values-for-seed-drops' TO 'true' TO USE THIS.", defaultProperties.seedSpawnChanceFromOre(), 0.0, 100.0, this);
        this.seedSpawnChanceFromOrganicOre = new DoubleConfigValue("seed-spawn-chance-from-organic-ore", "The chance (percentage) that this plant types seed will spawn\nwhen the plant produce block is blown up with TNT.\nSet this to 0 to prevent the seeds from spawning when blowing\nup the plant produce blocks.\nYOU MUST SET 'use-configuration-values-for-seed-drops' TO 'true' TO USE THIS.", defaultProperties.seedSpawnChanceFromOrganicOre(), 0.0, 100.0, this);
        this.useConfigGrowthChanceValue = new BooleanConfigValue("use-configuration-values-for-growth", "Prevents the configuration value for 'chance-to-grow' from being used\nforcing the default value to be used instead, when this is 'false'.\nYou must set this to 'true' before the 'chance-to-grow' config value will work!", false, this);
        this.useConfigSeedChanceValues = new BooleanConfigValue("use-configuration-values-for-seed-drops", "Prevents the configuration values for 'seed-spawn-chance-*' from being used\nforcing the default value to be used instead, when this is 'false'.\nYou must set this to 'true' before the 'seed-spawn-chance-*' config values will work!", false, this);
    }

    @Override
    public boolean bonemealGrowth() {
        return this.canUseBonemeal.getValue();
    }

    @Override
    public float growthProbability() {
        if (!this.useConfigGrowthChanceValue.getValue()) {
            return Float.parseFloat(this.chanceToGrow.getDefaultValue().toString());
        }
        return (float)this.chanceToGrow.getValue();
    }

    @Override
    public float seedSpawnChanceFromOre() {
        if (!this.useConfigSeedChanceValues.getValue()) {
            return Float.parseFloat(this.seedSpawnChanceFromOre.getDefaultValue().toString());
        }
        return (float)this.seedSpawnChanceFromOre.getValue();
    }

    @Override
    public float seedSpawnChanceFromOrganicOre() {
        if (!this.useConfigSeedChanceValues.getValue()) {
            return Float.parseFloat(this.seedSpawnChanceFromOrganicOre.getDefaultValue().toString());
        }
        return (float)this.seedSpawnChanceFromOrganicOre.getValue();
    }
}

