/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.DoubleConfigValue;
import com.ki11erwolf.resynth.config.IntegerConfigValue;
import com.ki11erwolf.resynth.plant.set.properties.AbstractProduceProperties;
import java.util.Objects;

public class ProducePropertiesConfig
extends ConfigCategory
implements AbstractProduceProperties {
    private static final String PREFIX = "plant-set-";
    private static final String SUFFIX = ".produce-smelting";
    private final IntegerConfigValue resourceCountConfig;
    private final IntegerConfigValue smeltingTimeConfig;
    private final DoubleConfigValue experienceWorthConfig;
    private final BooleanConfigValue useConfigValues;

    public ProducePropertiesConfig(String uniqueName, AbstractProduceProperties defaultProperties) {
        super(PREFIX + Objects.requireNonNull(uniqueName) + SUFFIX);
        this.resourceCountConfig = new IntegerConfigValue("number-of-resources-when-smelted", "The amount of resource items a player will get for smelting\na single item of this plants produce. Change this number to\nincrease or decrease the amount of resources a single item of\nproduce gives when smelted in a furnace.", defaultProperties.produceYield(), 1, 64, this);
        this.smeltingTimeConfig = new IntegerConfigValue("number-of-ticks-to-smelt", "The amount of time it takes a furnace to smelt a single item\nof this plants produce. The time is measured in ticks, where\n1 second is 20 ticks, so 1 ticks is 50 milliseconds. Most\nitems take 200 ticks (10 seconds) to smelt.", defaultProperties.timePerYield(), 1, 2000, this);
        this.experienceWorthConfig = new DoubleConfigValue("amount-of-xp-when-smelted", "The amount of xp (experience) a player will get from a furnace\nafter smelting a single item of this plants produce. It takes\nexactly 7.5 points to go from level 0 to level 1. Going from\nlevel 1 to level 2 will take slightly more than 7.5 points.", defaultProperties.experiencePoints(), 1.0, 1000.0, this);
        this.useConfigValues = new BooleanConfigValue("use-config-values", "Enable this configuration option to use the other options in this category!\nControls if the configuration values in this category are actually\nused instead of the default values. By default, changing the values of\nthe other setting in this category will have no effect unless this value\nis set to 'true'. Note that enabling this will prevent changes to these\nsetting in future Resynth updates from being applied.", false, this);
    }

    @Override
    public int produceYield() {
        if (this.useConfigValues.getValue()) {
            return this.resourceCountConfig.getValue();
        }
        return Integer.parseInt(this.resourceCountConfig.getDefaultValue().toString());
    }

    @Override
    public int timePerYield() {
        if (this.useConfigValues.getValue()) {
            return this.smeltingTimeConfig.getValue();
        }
        return Integer.parseInt(this.smeltingTimeConfig.getDefaultValue().toString());
    }

    @Override
    public double experiencePoints() {
        if (this.useConfigValues.getValue()) {
            return this.experienceWorthConfig.getValue();
        }
        return Double.parseDouble(this.experienceWorthConfig.getDefaultValue().toString());
    }
}

