/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.features;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.features.ResynthFeatures;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import org.apache.logging.log4j.Logger;

public abstract class ResynthFeature<T extends ResynthFeature<T>> {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private final ResourceLocation id;
    private final List<Biome.Category> biomes;
    private ConfiguredFeature<?, ?> feature;

    protected ResynthFeature(ResourceLocation id, Biome.Category[] biomes) {
        this.id = Objects.requireNonNull(id);
        this.biomes = Arrays.asList(biomes);
    }

    protected abstract ConfiguredFeature<?, ?> constructFeature();

    protected abstract void onConfigureFeature(BiomeGenerationSettingsBuilder var1) throws Exception;

    protected final void configure(BiomeGenerationSettingsBuilder builder, Biome.Category biomeCategory) {
        if (!this.biomes.contains(biomeCategory)) {
            return;
        }
        try {
            LOG.debug("Configuring Resynth feature: '" + this.id.toString() + "' for biome: '" + biomeCategory.func_222352_a() + "'...");
            this.onConfigureFeature(builder);
        }
        catch (Exception e) {
            LOG.error("Failed to configure feature: " + this.id.toString(), (Throwable)e);
        }
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public ConfiguredFeature<?, ?> getFeature() {
        return this.feature == null ? (this.feature = this.constructFeature()) : this.feature;
    }

    public ResynthFeature<T> register() {
        return ResynthFeatures.addFeature(this);
    }
}

