/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.features;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.CalviniteGenConfig;
import com.ki11erwolf.resynth.config.categories.MineralStoneGenConfig;
import com.ki11erwolf.resynth.config.categories.SeedPodConfig;
import com.ki11erwolf.resynth.config.categories.SylvaniteGenConfig;
import com.ki11erwolf.resynth.features.MatchBlockListRuleTest;
import com.ki11erwolf.resynth.features.ResynthFeature;
import com.ki11erwolf.resynth.features.ResynthFlowerFeature;
import com.ki11erwolf.resynth.features.ResynthOreFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="resynth", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ResynthFeatures {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static final List<ResynthFeature<?>> FEATURE_LIST = new ArrayList();
    private static final SeedPodConfig MYSTICAL_SEED_POD_CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(SeedPodConfig.class);
    private static final MineralStoneGenConfig MINERAL_STONE_GEN_CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(MineralStoneGenConfig.class);
    private static final CalviniteGenConfig CALVINITE_GEN_CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(CalviniteGenConfig.class);
    private static final SylvaniteGenConfig SYLVANITE_GEN_CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(SylvaniteGenConfig.class);
    private static final ResynthFeature<ResynthFlowerFeature> MYSTICAL_SEED_POD = new ResynthFlowerFeature(new ResourceLocation("resynth", "mystical_seed_pod_flower"), ResynthFeatures.getOverworldBiomes(), ResynthBlocks.BLOCK_SEED_POD, MYSTICAL_SEED_POD_CONFIG.getRarity(), MYSTICAL_SEED_POD_CONFIG.getSize()).register();
    private static final ResynthFeature<ResynthOreFeature> MINERAL_STONE = new ResynthOreFeature(new ResourceLocation("resynth", "mineral_stone_ore"), ResynthFeatures.getOverworldBiomes(), ResynthBlocks.BLOCK_MINERAL_STONE, MatchBlockListRuleTest.MATCH_OVERWORLD_ROCK, MINERAL_STONE_GEN_CONFIG.getRarity(), MINERAL_STONE_GEN_CONFIG.getSize(), MINERAL_STONE_GEN_CONFIG.getMinimumHeight(), MINERAL_STONE_GEN_CONFIG.getMaximumHeight()).register();
    private static final ResynthFeature<ResynthOreFeature> CALVINITE = new ResynthOreFeature(new ResourceLocation("resynth", "calvinite_ore"), ResynthFeatures.getNetherworldBiomes(), ResynthBlocks.BLOCK_CALVINITE_NETHERRACK, MatchBlockListRuleTest.MATCH_NETHERWORLD_ROCK, CALVINITE_GEN_CONFIG.getRarity(), CALVINITE_GEN_CONFIG.getSize(), CALVINITE_GEN_CONFIG.getMinimumHeight(), CALVINITE_GEN_CONFIG.getMaximumHeight()).register();
    private static final ResynthFeature<ResynthOreFeature> SYLVANITE = new ResynthOreFeature(new ResourceLocation("resynth", "sylvanite_ore"), ResynthFeatures.getEndworldBiomes(), ResynthBlocks.BLOCK_SYLVANITE_END_STONE, MatchBlockListRuleTest.MATCH_ENDWORLD_ROCK, SYLVANITE_GEN_CONFIG.getRarity(), SYLVANITE_GEN_CONFIG.getSize(), SYLVANITE_GEN_CONFIG.getMinimumHeight(), SYLVANITE_GEN_CONFIG.getMaximumHeight()).register();

    private ResynthFeatures() {
    }

    public static void init() {
    }

    protected static <T extends ResynthFeature<?>> T addFeature(T feature) {
        FEATURE_LIST.add(Objects.requireNonNull(feature));
        return feature;
    }

    private static void onBiomeLoading(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        FEATURE_LIST.forEach(resynthFeature -> resynthFeature.configure(generation, event.getCategory()));
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry featureRegistry = event.getRegistry();
        FEATURE_LIST.stream().peek(feature -> LOG.info("Registering ResynthFeature {}.", (Object)feature.getID().toString())).filter(feature -> feature.getFeature() != null).forEach(feature -> {
            ConfiguredFeature cfr_ignored_0 = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)feature.getID(), feature.getFeature());
        });
    }

    private static Biome.Category[] getOverworldBiomes() {
        return new Biome.Category[]{Biome.Category.TAIGA, Biome.Category.EXTREME_HILLS, Biome.Category.JUNGLE, Biome.Category.MESA, Biome.Category.PLAINS, Biome.Category.SAVANNA, Biome.Category.ICY, Biome.Category.BEACH, Biome.Category.FOREST, Biome.Category.OCEAN, Biome.Category.DESERT, Biome.Category.RIVER, Biome.Category.SWAMP, Biome.Category.MUSHROOM};
    }

    private static Biome.Category[] getNetherworldBiomes() {
        return new Biome.Category[]{Biome.Category.NETHER};
    }

    private static Biome.Category[] getEndworldBiomes() {
        return new Biome.Category[]{Biome.Category.THEEND};
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(ResynthFeatures::onBiomeLoading);
    }
}

