/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.features;

import com.ki11erwolf.resynth.features.MatchBlockListRuleTest;
import com.ki11erwolf.resynth.features.ResynthFeature;
import com.ki11erwolf.resynth.util.MathUtil;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public class ResynthFlowerFeature
extends ResynthFeature<ResynthFlowerFeature> {
    private static final RuleTest TARGET_FLOWERS = new MatchBlockListRuleTest(Blocks.field_150349_c, Blocks.field_196554_aH, Blocks.field_196555_aI, Blocks.field_196606_bd, Blocks.field_196605_bc, Blocks.field_196607_be, Blocks.field_196800_gd, Blocks.field_196616_bl, Blocks.field_196803_gg);
    private static final TopSolidRangeConfig FLOWER_HEIGHT_RANGE = new TopSolidRangeConfig(50, 50, 255);
    private final Block flower;
    private final int patchRarity;
    private final int patchSize;

    protected ResynthFlowerFeature(ResourceLocation id, Biome.Category[] biomes, Block flower, int patchRarity, int patchSize) {
        super(id, biomes);
        this.flower = Objects.requireNonNull(flower);
        this.patchRarity = MathUtil.within(patchRarity, 1, 64);
        this.patchSize = MathUtil.within(patchSize, 1, 64);
    }

    @Override
    protected ConfiguredFeature<?, ?> constructFeature() {
        return (ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(TARGET_FLOWERS, this.flower.func_176223_P(), this.patchSize)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)FLOWER_HEIGHT_RANGE)).func_242731_b(this.patchRarity);
    }

    @Override
    protected void onConfigureFeature(BiomeGenerationSettingsBuilder builder) throws Exception {
        if (this.flower.getRegistryName() == null) {
            throw new Exception("Flower registry name is null");
        }
        if (this.getFeature() == null) {
            throw new Exception("Flower Feature was not constructed correctly!");
        }
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, this.getFeature());
    }
}

