/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.features;

import com.ki11erwolf.resynth.features.ResynthFeature;
import com.ki11erwolf.resynth.util.MathUtil;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public class ResynthOreFeature
extends ResynthFeature<ResynthOreFeature> {
    private final Block ore;
    private final RuleTest target;
    private final int veinRarity;
    private final int veinSize;
    private final int veinMinHeight;
    private final int veinMaxHeight;

    protected ResynthOreFeature(ResourceLocation id, Biome.Category[] biomes, Block ore, RuleTest target, int rarity, int size, int minHeight, int maxHeight) {
        super(id, biomes);
        this.ore = Objects.requireNonNull(ore);
        this.target = Objects.requireNonNull(target);
        this.veinRarity = MathUtil.within(rarity, 1, 64);
        this.veinSize = MathUtil.within(size, 1, 64);
        this.veinMinHeight = MathUtil.within(minHeight, 1, 254);
        this.veinMaxHeight = MathUtil.within(maxHeight, minHeight + 1, 255);
    }

    @Override
    protected ConfiguredFeature<?, ?> constructFeature() {
        return (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(this.target, this.ore.func_176223_P(), this.veinSize)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(this.veinMinHeight, this.veinMinHeight, this.veinMaxHeight))).func_242728_a()).func_242731_b(this.veinRarity);
    }

    @Override
    protected void onConfigureFeature(BiomeGenerationSettingsBuilder builder) throws Exception {
        if (this.ore.getRegistryName() == null) {
            throw new Exception("Ore registry name is null");
        }
        if (this.getFeature() == null) {
            throw new Exception("Ore Feature was not constructed correctly!");
        }
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, this.getFeature());
    }
}

