/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.MineralHoeConfig;
import com.ki11erwolf.resynth.item.ResynthItem;
import com.ki11erwolf.resynth.item.ResynthItems;
import com.ki11erwolf.resynth.packet.DisplayHoeInfoPacket;
import com.ki11erwolf.resynth.packet.Packet;
import com.ki11erwolf.resynth.util.CommonTooltips;
import com.ki11erwolf.resynth.util.EffectsUtil;
import com.ki11erwolf.resynth.util.ExpandingTooltip;
import com.ki11erwolf.resynth.util.JSerializer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.logging.log4j.Logger;

public class ItemMineralHoe
extends ResynthItem<ItemMineralHoe> {
    private static final MineralHoeConfig CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(MineralHoeConfig.class);
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static final String NBT_TAG_CHARGES = "charges";

    ItemMineralHoe(String name) {
        super(new Item.Properties().func_200917_a(1), name);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemMineralHoe.ensureChargesNBT(stack);
        if (stack.func_77978_p() == null) {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            return;
        }
        new ExpandingTooltip().setConditionToControlDown().setExpandedTooltip(CommonTooltips.NEW_LINE).setCollapsedTooltip(null).write(tooltip);
        tooltip.add(ItemMineralHoe.getFormattedTooltip("mineral_hoe_charges", TextFormatting.GOLD, ItemMineralHoe.getCharges(stack) > 1 ? TextFormatting.AQUA : TextFormatting.RED, ItemMineralHoe.getCharges(stack)));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private static void ensureChargesNBT(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            LOG.debug("Setting NBT tag on a Mineral Hoe item stack...");
            nbt = new CompoundNBT();
            nbt.func_74768_a(NBT_TAG_CHARGES, Math.min(CONFIG.getInitialCharges(), 2));
            stack.func_77982_d(nbt);
        }
    }

    private static int getCharges(ItemStack stack) {
        ItemMineralHoe.ensureChargesNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag == null ? -1 : tag.func_74762_e(NBT_TAG_CHARGES);
    }

    private static boolean setCharges(ItemStack stack, int charges) {
        ItemMineralHoe.ensureChargesNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        tag.func_74768_a(NBT_TAG_CHARGES, charges);
        stack.func_77982_d(tag);
        return true;
    }

    private static boolean incrementCharges(ItemStack stack) {
        int charges = ItemMineralHoe.getCharges(stack);
        if (charges >= CONFIG.getMaxCharges()) {
            return false;
        }
        return ItemMineralHoe.setCharges(stack, charges + 1);
    }

    private static boolean decrementCharges(ItemStack stack) {
        int charges = ItemMineralHoe.getCharges(stack);
        if (charges <= 0) {
            return false;
        }
        return ItemMineralHoe.setCharges(stack, charges - 1);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        boolean success = context.func_195999_j() == null ? false : (context.func_195999_j().func_213453_ef() ? this.onBlockShiftClick(context.func_195991_k(), context.func_195995_a(), context.func_195991_k().func_180495_p(context.func_195995_a()), context.func_195996_i(), context.func_195999_j()) : this.onBlockClick(context.func_195991_k(), context.func_195995_a(), context.func_195991_k().func_180495_p(context.func_195995_a()), context.func_195996_i(), context.func_195999_j(), context.func_196000_l()));
        return success ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean success = player.func_213453_ef() ? this.onItemShiftClick(world, player, stack) : this.onItemClick(world, player, stack);
        return success ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226251_d_((Object)stack);
    }

    private boolean onBlockClick(World world, BlockPos pos, BlockState block, ItemStack item, PlayerEntity player, Direction face) {
        boolean tilled = this.tryTillBlock(world, pos, block, item, player, face);
        if (!tilled) {
            return this.tryGetBlockInfoAsProvider(world, pos, block, player);
        }
        return true;
    }

    private boolean onBlockShiftClick(World world, BlockPos pos, BlockState block, ItemStack item, PlayerEntity player) {
        if (this.tryGrowPlant(player, world, block, pos)) {
            return true;
        }
        return this.tryCharge(world, player, item);
    }

    private boolean onItemClick(World world, PlayerEntity player, ItemStack item) {
        return this.tryCharge(world, player, item);
    }

    private boolean onItemShiftClick(World world, PlayerEntity player, ItemStack item) {
        boolean charged = this.tryCharge(world, player, item);
        if (!charged) {
            this.displayCharges(world, player, item);
        }
        return charged;
    }

    private boolean tryCharge(World world, PlayerEntity player, ItemStack item) {
        int charges = ItemMineralHoe.getCharges(item);
        if (charges >= CONFIG.getMaxCharges()) {
            return false;
        }
        if ((player.func_184812_l_() || this.tryTakeCrystal(player)) && ItemMineralHoe.incrementCharges(item)) {
            if (CONFIG.playChargeSound()) {
                EffectsUtil.playNormalSound(world, player, new BlockPos(player.func_213303_ch()), SoundEvents.field_193808_ex, SoundCategory.BLOCKS);
            }
            this.displayCharges(world, player, item);
            return true;
        }
        return false;
    }

    private boolean tryTakeCrystal(PlayerEntity player) {
        for (ItemStack itemStack : player.field_71069_bz.func_75138_a()) {
            if (itemStack.func_77973_b() != ResynthItems.ITEM_MINERAL_CRYSTAL) continue;
            itemStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    private void displayCharges(World world, PlayerEntity player, ItemStack item) {
        if (!world.field_72995_K) {
            return;
        }
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + ItemMineralHoe.getFormattedTooltip("mineral_hoe_charges", TextFormatting.GOLD, ItemMineralHoe.getCharges(item) > 1 ? TextFormatting.AQUA : TextFormatting.RED, ItemMineralHoe.getCharges(item)).getString()), player.func_110124_au());
    }

    private boolean tryTillBlock(World world, BlockPos pos, BlockState state, ItemStack item, PlayerEntity player, Direction face) {
        if (state.func_177230_c() != Blocks.field_150346_d && state.func_177230_c() != Blocks.field_196658_i) {
            return false;
        }
        if (face == Direction.DOWN || !world.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        if (!player.func_184812_l_() && ItemMineralHoe.getCharges(item) <= 0) {
            if (CONFIG.playFailSound()) {
                EffectsUtil.playNormalSound(world, player, pos, SoundEvents.field_187685_dH, SoundCategory.BLOCKS);
            }
            return false;
        }
        boolean replaced = this.tillBlock(world, pos, player);
        if (replaced && !player.func_184812_l_()) {
            ItemMineralHoe.decrementCharges(item);
        }
        return replaced;
    }

    private boolean tillBlock(World world, BlockPos pos, PlayerEntity player) {
        boolean replaced = world.func_175656_a(pos, ResynthBlocks.BLOCK_MINERAL_SOIL.func_176223_P());
        if (replaced) {
            if (CONFIG.showParticles()) {
                EffectsUtil.displayStandardEffects(world, pos.func_177984_a(), 5, (IParticleData)ParticleTypes.field_197631_x);
            }
            EffectsUtil.playNormalSound(world, player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS);
        }
        return replaced;
    }

    private boolean tryGrowPlant(PlayerEntity player, World world, BlockState block, BlockPos pos) {
        if (!player.func_184812_l_()) {
            return false;
        }
        if (block.func_177230_c() instanceof IGrowable) {
            if (!world.field_72995_K) {
                ((IGrowable)block.func_177230_c()).func_225535_a_((ServerWorld)world, field_77697_d, pos, world.func_180495_p(pos));
            }
            return true;
        }
        return false;
    }

    private boolean tryGetBlockInfoAsProvider(World world, BlockPos pos, BlockState block, PlayerEntity player) {
        Map<String, Object[]> information;
        MineralHoeInfoProvider provider = this.asInfoProvider(block);
        if (provider != null) {
            information = ItemMineralHoe.callInfoProvider(provider, block, world, pos);
            if (information == null) {
                return false;
            }
        } else {
            return false;
        }
        if (player instanceof ServerPlayerEntity) {
            Packet.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), new DisplayHoeInfoPacket(new MineralHoeInformation(information)));
            return true;
        }
        return false;
    }

    @Nullable
    private MineralHoeInfoProvider asInfoProvider(BlockState blockState) {
        if (blockState.func_177230_c() instanceof MineralHoeInfoProvider) {
            return (MineralHoeInfoProvider)blockState.func_177230_c();
        }
        return null;
    }

    @Nullable
    private static Map<String, Object[]> callInfoProvider(MineralHoeInfoProvider provider, BlockState state, World world, BlockPos pos) {
        boolean passed;
        Map<String, Object[]> cleanMap = MineralHoeInformation.getNewMap();
        if (world.field_72995_K) {
            return null;
        }
        try {
            passed = provider.provideHoeInformation(cleanMap, state, world, pos);
        }
        catch (Exception e) {
            LOG.warn("Information provider '" + provider.getClass().getCanonicalName() + "' threw exception when queried", (Throwable)e);
            return null;
        }
        if (!passed || cleanMap.isEmpty()) {
            return null;
        }
        return cleanMap;
    }

    public static interface MineralHoeInfoProvider {
        public boolean provideHoeInformation(Map<String, Object[]> var1, BlockState var2, World var3, BlockPos var4);
    }

    public static class MineralHoeInformation
    implements JSerializer.JSerializable<MineralHoeInformation> {
        public static JSerializer<MineralHoeInformation> INFORMATION_SERIALIZER_INSTANCE = new Serializer();
        private static final String SERIALIZER_IDENTIFICATION = "mineral-hoe-information";
        private static final String INFORMATION_MAP_KEY = "information-map";
        private final Map<String, Object[]> information;

        private MineralHoeInformation() {
            this(MineralHoeInformation.getNewMap());
        }

        private MineralHoeInformation(Map<String, Object[]> information) {
            this.information = Objects.requireNonNull(information);
        }

        @Override
        public JSerializer<MineralHoeInformation> getSerializer() {
            return INFORMATION_SERIALIZER_INSTANCE;
        }

        public Map<String, Object[]> getInformation() {
            return this.information;
        }

        static Map<String, Object[]> getNewMap() {
            return new LinkedHashMap<String, Object[]>();
        }

        private static final class Serializer
        extends JSerializer<MineralHoeInformation> {
            private Serializer() {
                super(MineralHoeInformation.SERIALIZER_IDENTIFICATION);
            }

            @Override
            protected void objectToData(MineralHoeInformation object, JSerializer.JSerialDataIO dataIO) {
                Map<String, Object[]> information = object.getInformation();
                if (information.isEmpty()) {
                    throw new IllegalArgumentException("HoeInformation object contains empty information map.");
                }
                JsonObject jsonInformationMap = new JsonObject();
                for (Map.Entry<String, Object[]> info : information.entrySet()) {
                    JsonArray array = new JsonArray();
                    String key = info.getKey();
                    for (Object element : info.getValue()) {
                        array.add(element.toString());
                    }
                    jsonInformationMap.add(key, (JsonElement)array);
                }
                dataIO.add(MineralHoeInformation.INFORMATION_MAP_KEY, (JsonElement)jsonInformationMap);
            }

            @Override
            protected MineralHoeInformation dataToObject(MineralHoeInformation newObject, JSerializer.JSerialDataIO dataIO) {
                JsonObject jsonInformation = dataIO.getObject(MineralHoeInformation.INFORMATION_MAP_KEY, null);
                Map<String, Object[]> information = MineralHoeInformation.getNewMap();
                if (jsonInformation == null || jsonInformation.size() == 0) {
                    throw new IllegalArgumentException("HoeInformation object data gave an empty map.");
                }
                for (Map.Entry info : jsonInformation.entrySet()) {
                    String key = (String)info.getKey();
                    JsonArray jValues = ((JsonElement)info.getValue()).getAsJsonArray();
                    ArrayList<String> values = new ArrayList<String>();
                    for (JsonElement jElement : jValues) {
                        values.add(jElement.getAsString());
                    }
                    information.put(key, values.toArray(new String[0]));
                }
                return new MineralHoeInformation(information);
            }

            @Override
            protected MineralHoeInformation createInstance() {
                return new MineralHoeInformation();
            }
        }
    }
}

