/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.item;

import com.ki11erwolf.resynth.ResynthTabs;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.item.ResynthItems;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.util.ExpandingTooltip;
import com.ki11erwolf.resynth.util.Tooltip;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.text.WordUtils;

public class ResynthItem<T extends ResynthItem<?>>
extends Item {
    private boolean isQueued = false;

    ResynthItem(Item.Properties properties, String name) {
        super(ResynthItem.setItemGroup(properties));
        this.setRegistryName(name);
    }

    public ResynthItem(String name) {
        this(new Item.Properties(), name);
    }

    public ResynthItem(String name, ItemGroup group) {
        super(new Item.Properties().func_200916_a(group));
        this.setRegistryName(name);
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        new ExpandingTooltip().setCtrlForDescription(tooltips -> Tooltip.addBlankLine(tooltips).addAll(Arrays.asList(Tooltip.formatLineFeeds(ResynthItem.getDescriptiveTooltip(this), TextFormatting.DARK_GRAY)))).write(tooltip).add(Tooltip.newBlankLine());
    }

    ResynthItem<T> queueRegistration() {
        if (this.isQueued) {
            throw new IllegalStateException(String.format("Item: %s already queued for registration.", ((Object)((Object)this)).getClass().getCanonicalName()));
        }
        ResynthItems.INSTANCE.queueForRegistration(this);
        this.isQueued = true;
        return this;
    }

    protected static void addPlantItemTooltips(List<ITextComponent> tooltip, String itemName, PlantSet<?, ?> parentSet) {
        Tooltip.addPlantItemOrBlockTooltips(tooltip, parentSet, ResynthItem.getDescriptiveTooltip(itemName, new Object[0]));
    }

    private static Item.Properties setItemGroup(Item.Properties properties) {
        properties.func_200916_a(ResynthTabs.TAB_RESYNTH);
        return properties;
    }

    protected static ITextComponent getFormattedTooltip(String key, TextFormatting color, Object ... params) {
        return Tooltip.toTextComponent(color + I18n.func_135052_a((String)("tooltip.item.resynth." + key), (Object[])params));
    }

    protected static ITextComponent getDescriptiveTooltip(ResynthItem<?> item) {
        return item == null || item.getRegistryName() == null ? Tooltip.toTextComponent(TextFormatting.RED + "Error") : ResynthItem.getDescriptiveTooltip(item.getRegistryName().func_110623_a(), new Object[0]);
    }

    protected static ITextComponent getDescriptiveTooltip(String key, Object ... params) {
        if (key == null) {
            return Tooltip.toTextComponent(TextFormatting.RED + "Error");
        }
        return Tooltip.toTextComponent(WordUtils.wrap((String)(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)("tooltip.item.resynth." + key), (Object[])params)), (int)ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).getTooltipCharacterLimit(), (String)"\n", (boolean)true));
    }
}

