/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.packet;

import com.google.gson.JsonSyntaxException;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.packet.Packet;
import com.ki11erwolf.resynth.util.EffectsUtil;
import com.ki11erwolf.resynth.util.JSerializer;
import com.ki11erwolf.resynth.util.SideUtil;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Logger;

public class ClientAVEffectPacket
extends Packet<ClientAVEffectPacket>
implements JSerializer.JSerializable<ClientAVEffectPacket> {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private final AVEffect audioVisualEffect;
    private final BlockPos position;

    public ClientAVEffectPacket(AVEffect audioVisualEffect, BlockPos position) {
        this.audioVisualEffect = Objects.requireNonNull(audioVisualEffect);
        this.position = Objects.requireNonNull(position);
    }

    @Override
    BiConsumer<ClientAVEffectPacket, PacketBuffer> getEncoder() {
        return ClientAVEffectPacket::encode;
    }

    private static void encode(ClientAVEffectPacket effectPacket, PacketBuffer packetBuffer) {
        try {
            ClientAVEffectPacket.writeString(JSerializer.serialize(effectPacket).getDataAsJsonString(), packetBuffer);
        }
        catch (JSerializer.SerializeException exception) {
            LOG.error("Failed to serialize and encode ClientAudioVisualEffectPacket!", (Throwable)exception);
        }
    }

    @Override
    Function<PacketBuffer, ClientAVEffectPacket> getDecoder() {
        return ClientAVEffectPacket::decode;
    }

    private static ClientAVEffectPacket decode(PacketBuffer packetBuffer) {
        try {
            JSerializer.JSerialData packetSerialData = JSerializer.JSerialData.fromJsonString(ClientAVEffectPacket.readString(packetBuffer));
            ClientAVEffectPacket deserializedPacket = JSerializer.deserialize(packetSerialData, PacketSerializer.SERIALIZER);
            if (deserializedPacket == null || deserializedPacket.audioVisualEffect == AVEffect.NONE) {
                throw new IllegalArgumentException("Deserialized ClientAudioVisualEffectPacket is null or has no effect.");
            }
            return deserializedPacket;
        }
        catch (JsonSyntaxException | JSerializer.SerializeException | IllegalArgumentException exception) {
            LOG.error("Failed to deserialize and decode ClientAudioVisualEffectPacket!", exception);
            return new ClientAVEffectPacket(AVEffect.NONE, new BlockPos(0, 0, 0));
        }
    }

    @Override
    BiConsumer<ClientAVEffectPacket, Supplier<NetworkEvent.Context>> getHandler() {
        return ClientAVEffectPacket::handle;
    }

    private static void handle(ClientAVEffectPacket effectPacket, Supplier<NetworkEvent.Context> supplier) {
        Packet.handle(supplier, () -> {
            if (!SideUtil.isClientTrueSafe()) {
                LOG.error("Attempted to handle ClientAudioVisualEffect on server! Skipping...");
                return;
            }
            if (effectPacket.audioVisualEffect == AVEffect.NONE) {
                LOG.error("ClientAudioVisualEffect: " + AVEffect.NONE.getSerialID() + " requested.");
                return;
            }
            LOG.debug("Playing ClientAudioVisualEffect: " + effectPacket.audioVisualEffect.getSerialID());
            effectPacket.audioVisualEffect.play(effectPacket.position);
        });
    }

    public PacketSerializer getSerializer() {
        return PacketSerializer.SERIALIZER;
    }

    private static class PacketSerializer
    extends JSerializer<ClientAVEffectPacket> {
        private static final PacketSerializer SERIALIZER = new PacketSerializer("client-effect-packet");

        public PacketSerializer(String identification) {
            super(identification);
        }

        @Override
        protected void objectToData(ClientAVEffectPacket object, JSerializer.JSerialDataIO dataIO) throws Exception {
            dataIO.add("effect-id", object.audioVisualEffect.getSerialID());
            dataIO.add("pos-x", object.position.func_177958_n());
            dataIO.add("pos-y", object.position.func_177956_o());
            dataIO.add("pos-z", object.position.func_177952_p());
        }

        @Override
        protected ClientAVEffectPacket dataToObject(ClientAVEffectPacket suggestedObject, JSerializer.JSerialDataIO dataIO) throws Exception {
            return new ClientAVEffectPacket(AVEffect.fromSerialID(dataIO.getString("effect-id")), new BlockPos(dataIO.getInteger("pos-x"), dataIO.getInteger("pos-y"), dataIO.getInteger("pos-z")));
        }

        @Override
        protected ClientAVEffectPacket createInstance() {
            return new ClientAVEffectPacket(AVEffect.NONE, new BlockPos(0, 0, 0));
        }
    }

    public static enum AVEffect {
        NONE("none"),
        SEEDS_SPAWNED("seeds_spawned"){

            @Override
            protected void play(BlockPos pos) {
                if (Minecraft.func_71410_x().field_71439_g == null) {
                    LOG.error("Cannot play AudioVisualEffect! Client Player instance is null.");
                    return;
                }
                EffectsUtil.displayStandardEffectsOnClient(pos, 10, (IParticleData)ParticleTypes.field_218419_B);
                EffectsUtil.playNormalSoundWithVolumeOnClient(pos, SoundEvents.field_193807_ew, SoundCategory.PLAYERS, 8.0f);
            }
        };

        private final String serialID;

        private AVEffect(String serialID) {
            this.serialID = Objects.requireNonNull(serialID);
        }

        protected String getSerialID() {
            return this.serialID;
        }

        protected void play(BlockPos pos) {
            throw new UnsupportedOperationException();
        }

        protected static AVEffect fromSerialID(String serialID) {
            for (AVEffect effect : AVEffect.values()) {
                if (!effect.getSerialID().equals(serialID)) continue;
                return effect;
            }
            return null;
        }
    }
}

