/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.packet;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.item.ItemMineralHoe;
import com.ki11erwolf.resynth.packet.Packet;
import com.ki11erwolf.resynth.util.JSerializer;
import com.ki11erwolf.resynth.util.SideUtil;
import com.ki11erwolf.resynth.util.Tooltip;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Logger;

public class DisplayHoeInfoPacket
extends Packet<DisplayHoeInfoPacket> {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private final ItemMineralHoe.MineralHoeInformation information;

    public DisplayHoeInfoPacket(ItemMineralHoe.MineralHoeInformation information) {
        this.information = information;
    }

    @Override
    BiConsumer<DisplayHoeInfoPacket, PacketBuffer> getEncoder() {
        return (mineralHoeInfoPacket, packetBuffer) -> {
            try {
                String jsonHoeInfo = ItemMineralHoe.MineralHoeInformation.INFORMATION_SERIALIZER_INSTANCE.serializeObject(mineralHoeInfoPacket.information).getDataAsJsonString();
                DisplayHoeInfoPacket.writeString(jsonHoeInfo, packetBuffer);
            }
            catch (JSerializer.SerializeException e) {
                LOG.error("Failed to encode DisplayHoeInfoPacket - exception when serializing data.", (Throwable)e);
            }
        };
    }

    @Override
    Function<PacketBuffer, DisplayHoeInfoPacket> getDecoder() {
        try {
            return packetBuffer -> new DisplayHoeInfoPacket(ItemMineralHoe.MineralHoeInformation.INFORMATION_SERIALIZER_INSTANCE.deserializeData(JSerializer.JSerialData.fromJsonString(DisplayHoeInfoPacket.readString(packetBuffer))));
        }
        catch (JSerializer.SerializeException e) {
            LOG.error("Failed to decode DisplayHoeInfoPacket - exception when deserializing data.", (Throwable)e);
            return packetBuffer -> new DisplayHoeInfoPacket(null);
        }
    }

    @Override
    BiConsumer<DisplayHoeInfoPacket, Supplier<NetworkEvent.Context>> getHandler() {
        return (displayHoeInfoPacket, supplier) -> Packet.handle(supplier, () -> {
            if (displayHoeInfoPacket.information == null) {
                LOG.error("Skipping handling of DisplayHoeInfoPacket - information is null.");
                return;
            }
            if (!SideUtil.isClientTrueSafe()) {
                LOG.error("Skipping handling of DisplayHoeInfoPacket - not executing on physical client.");
                return;
            }
            Map<String, Object[]> hoeInfo = displayHoeInfoPacket.information.getInformation();
            StringBuilder message = new StringBuilder();
            for (Map.Entry<String, Object[]> lineInfo : hoeInfo.entrySet()) {
                String key = "message.resynth.mineral_hoe_information." + lineInfo.getKey();
                Object[] values = lineInfo.getValue();
                for (int i = 0; i < values.length; ++i) {
                    if (!values[i].toString().startsWith("$")) continue;
                    values[i] = I18n.func_135052_a((String)("value.resynth.mineral_hoe_information." + values[i]).replace("$", ""), (Object[])new Object[0]);
                }
                message.append(I18n.func_135052_a((String)key, (Object[])values)).append("\n");
            }
            ClientPlayerEntity player = Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g);
            for (ITextComponent msg : Tooltip.formatLineFeeds((ITextComponent)new StringTextComponent(message.toString()))) {
                player.func_145747_a(msg, player.func_110124_au());
            }
        });
    }
}

