/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.packet;

import com.ki11erwolf.resynth.packet.ClientAVEffectPacket;
import com.ki11erwolf.resynth.packet.DisplayHoeInfoPacket;
import com.ki11erwolf.resynth.packet.SyncSetPropertiesPacket;
import com.ki11erwolf.resynth.plant.set.properties.MetallicProperties;
import com.ki11erwolf.resynth.plant.set.properties.ProduceProperties;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public abstract class Packet<S extends Packet<S>> {
    private static final PacketManager MANAGER = new PacketManager();

    Packet() {
    }

    abstract BiConsumer<S, PacketBuffer> getEncoder();

    abstract Function<PacketBuffer, S> getDecoder();

    abstract BiConsumer<S, Supplier<NetworkEvent.Context>> getHandler();

    static void writeString(String s, PacketBuffer buffer) {
        int chars = s.length();
        buffer.writeInt(chars);
        for (char c : s.toCharArray()) {
            buffer.writeChar((int)c);
        }
    }

    static String readString(PacketBuffer buffer) {
        int chars = buffer.readInt();
        StringBuilder string = new StringBuilder();
        for (int i = 0; i < chars; ++i) {
            char c = buffer.readChar();
            string.append(c);
        }
        return string.toString();
    }

    static void handle(Supplier<NetworkEvent.Context> context, Runnable runnable) {
        context.get().setPacketHandled(true);
        context.get().enqueueWork(runnable);
    }

    public static <M> void send(PacketDistributor.PacketTarget target, M packet) {
        MANAGER.handler.send(target, packet);
    }

    public static void init() {
    }

    static {
        MANAGER.register(new DisplayHoeInfoPacket(null), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MANAGER.register(new SyncSetPropertiesPacket("", new MetallicProperties(false, 0.0f, 0.0f, 0.0f), new ProduceProperties(0, 0, 0.0)), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MANAGER.register(new ClientAVEffectPacket(ClientAVEffectPacket.AVEffect.NONE, new BlockPos(0, 0, 0)), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    private static class PacketManager {
        private final String protocolVersion = Integer.toString(1);
        private final SimpleChannel handler = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("resynth", "basic-packet-channel")).clientAcceptedVersions(this.protocolVersion::equals).serverAcceptedVersions(this.protocolVersion::equals).networkProtocolVersion(() -> this.protocolVersion).simpleChannel();
        private int lastID = 0;

        private PacketManager() {
        }

        void register(Packet packet) {
            this.handler.registerMessage(this.lastID++, packet.getClass(), packet.getEncoder(), packet.getDecoder(), packet.getHandler());
        }

        void register(Packet packet, Optional<NetworkDirection> direction) {
            this.handler.registerMessage(this.lastID++, packet.getClass(), packet.getEncoder(), packet.getDecoder(), packet.getHandler(), direction);
        }
    }
}

