/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.packet;

import com.google.gson.JsonSyntaxException;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.packet.Packet;
import com.ki11erwolf.resynth.plant.set.PlantSetAPI;
import com.ki11erwolf.resynth.plant.set.properties.AbstractBiochemicalProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractCrystallineProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractMetallicProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractPlantSetProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractProduceProperties;
import com.ki11erwolf.resynth.util.JSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Logger;

public class SyncSetPropertiesPacket
extends Packet<SyncSetPropertiesPacket> {
    private static final Map<String, JSerializer<? extends AbstractPlantSetProperties>> TYPENAME_TO_SERIALIZER = new HashMap<String, JSerializer<? extends AbstractPlantSetProperties>>(){
        {
            this.put("biochemical", AbstractBiochemicalProperties.SERIALIZER);
            this.put("crystalline", AbstractCrystallineProperties.SERIALIZER);
            this.put("metallic", AbstractMetallicProperties.SERIALIZER);
        }
    };
    private static final Logger LOG = ResynthMod.getNewLogger();
    private final String setName;
    private final AbstractPlantSetProperties setProperties;
    private final AbstractProduceProperties produceProperties;

    public SyncSetPropertiesPacket(String setName, AbstractPlantSetProperties setProperties, AbstractProduceProperties produceProperties) {
        this.setName = Objects.requireNonNull(setName);
        this.setProperties = Objects.requireNonNull(setProperties);
        this.produceProperties = Objects.requireNonNull(produceProperties);
    }

    @Override
    BiConsumer<SyncSetPropertiesPacket, PacketBuffer> getEncoder() {
        return (propertiesPacket, packetBuffer) -> {
            AbstractPlantSetProperties props = propertiesPacket.setProperties;
            if (props instanceof AbstractBiochemicalProperties) {
                SyncSetPropertiesPacket.writeString("biochemical", packetBuffer);
                SyncSetPropertiesPacket.writeString(JSerializer.serialize((AbstractBiochemicalProperties)props).getDataAsJsonString(), packetBuffer);
            } else if (props instanceof AbstractCrystallineProperties) {
                SyncSetPropertiesPacket.writeString("crystalline", packetBuffer);
                SyncSetPropertiesPacket.writeString(JSerializer.serialize((AbstractCrystallineProperties)props).getDataAsJsonString(), packetBuffer);
            } else if (props instanceof AbstractMetallicProperties) {
                SyncSetPropertiesPacket.writeString("metallic", packetBuffer);
                SyncSetPropertiesPacket.writeString(JSerializer.serialize((AbstractMetallicProperties)props).getDataAsJsonString(), packetBuffer);
            } else {
                LOG.error("Cannot serialize and encode PlantSet Properties! Unknown set type.");
                return;
            }
            SyncSetPropertiesPacket.writeString(JSerializer.serialize(propertiesPacket.produceProperties).getDataAsJsonString(), packetBuffer);
            SyncSetPropertiesPacket.writeString(propertiesPacket.setName, packetBuffer);
        };
    }

    @Override
    Function<PacketBuffer, SyncSetPropertiesPacket> getDecoder() {
        return packetBuffer -> {
            String type = SyncSetPropertiesPacket.readString(packetBuffer);
            JSerializer<? extends AbstractPlantSetProperties> serializer = TYPENAME_TO_SERIALIZER.get(type);
            if (serializer == null) {
                LOG.error("Cannot deserialize and decode PlantSet Properties! Unknown set typename.");
                return null;
            }
            try {
                AbstractPlantSetProperties deserializedSetProperties = serializer.deserializeData(JSerializer.JSerialData.fromJsonString(SyncSetPropertiesPacket.readString(packetBuffer)));
                AbstractProduceProperties deserializedProduceProperties = AbstractProduceProperties.SERIALIZER.deserializeData(JSerializer.JSerialData.fromJsonString(SyncSetPropertiesPacket.readString(packetBuffer)));
                String deserializedSetName = SyncSetPropertiesPacket.readString(packetBuffer);
                return new SyncSetPropertiesPacket(deserializedSetName, deserializedSetProperties, deserializedProduceProperties);
            }
            catch (JsonSyntaxException | JSerializer.SerializeException | IllegalArgumentException exception) {
                LOG.error("Failed to deserialize PlantSet Properties!", exception);
                return null;
            }
        };
    }

    @Override
    BiConsumer<SyncSetPropertiesPacket, Supplier<NetworkEvent.Context>> getHandler() {
        return (packet, supplier) -> Packet.handle(supplier, () -> PlantSetAPI.synchronizePlantSetProperties(packet.setName, packet.setProperties, packet.produceProperties));
    }
}

