/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.plant.block.BlockPlant;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.util.MathUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.Item;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;

public abstract class BlockMetallicPlant
extends BlockPlant<BlockMetallicPlant> {
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockMetallicPlant(PlantSet<BlockMetallicPlant, Block> parentSet) {
        super(parentSet);
    }

    @Override
    IntegerProperty getGrowthProperty() {
        return IntegerProperty.func_177719_a((String)"growth_stage", (int)0, (int)8);
    }

    @Override
    VoxelShape[] getShapeByAge() {
        return new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0)};
    }

    @Override
    public int getMaxGrowthStage() {
        return 8;
    }

    @Override
    boolean dropsProduceWhenGrown() {
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    @Deprecated
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (blockIn == Block.func_149634_a((Item)this.getProduce().func_77973_b()) && ((Integer)worldIn.func_180495_p(pos).func_177229_b((Property)this.getGrowthProperty())).intValue() == this.getMaxGrowthStage()) {
            worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((Property)this.getGrowthProperty(), (Comparable)Integer.valueOf(this.getMaxGrowthStage() - 1)));
        }
    }

    @Nullable
    private Direction placeProduce(World world, BlockPos pos) {
        int random = MathUtil.getRandomIntegerInRange(0, 4);
        for (int i = 0; i < 4; ++i) {
            BlockPos pos1 = null;
            BlockState block = null;
            Direction facing = null;
            if (random > 3) {
                random = 0;
            }
            switch (random) {
                case 0: {
                    pos1 = pos.func_177978_c();
                    facing = Direction.NORTH;
                    block = world.func_180495_p(pos1);
                    break;
                }
                case 1: {
                    pos1 = pos.func_177968_d();
                    facing = Direction.SOUTH;
                    block = world.func_180495_p(pos1);
                    break;
                }
                case 2: {
                    pos1 = pos.func_177974_f();
                    facing = Direction.EAST;
                    block = world.func_180495_p(pos1);
                    break;
                }
                case 3: {
                    pos1 = pos.func_177976_e();
                    facing = Direction.WEST;
                    block = world.func_180495_p(pos1);
                }
            }
            if (block == null) {
                return null;
            }
            if (block.func_177230_c() == Blocks.field_150350_a && world.func_180495_p(pos1.func_177977_b()).func_200132_m()) {
                if (world.func_175656_a(pos1, Block.func_149634_a((Item)this.getProduce().func_77973_b()).func_176223_P())) {
                    return facing;
                }
                return null;
            }
            ++random;
        }
        return null;
    }

    @Override
    void onGrowPlantBlock(World world, BlockState state, BlockPos pos, int increase) {
        int growth = increase + this.getGrowthStage(state);
        if (growth >= this.getMaxGrowthStage()) {
            if (this.attemptAutoHarvest(growth, world, pos)) {
                this.setGrowthStage(world, pos, this.getPostHarvestGrowthStage());
                return;
            }
            growth = this.getMaxGrowthStage();
            Direction facing = this.placeProduce(world, pos);
            if (facing == null) {
                return;
            }
            world.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)this.getGrowthProperty(), (Comparable)Integer.valueOf(growth))).func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)facing), 2);
        } else {
            this.setGrowthStage(world, pos, growth);
        }
    }

    @Override
    protected int getPostHarvestGrowthStage() {
        return 5;
    }
}

