/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.block.BlockEnhancer;
import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.block.tileEntity.TileEntityMineralSoil;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.item.ItemMineralHoe;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.properties.AbstractPlantSetProperties;
import com.ki11erwolf.resynth.util.EffectsUtil;
import com.ki11erwolf.resynth.util.MathUtil;
import com.ki11erwolf.resynth.util.MinecraftUtil;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoAccessor;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public abstract class BlockPlant<T extends BlockPlant<T>>
extends ResynthBlock<T>
implements IPlantable,
IGrowable,
IComponentProvider,
IProbeInfoAccessor,
ItemMineralHoe.MineralHoeInfoProvider {
    private static final GeneralConfig GENERAL_CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class);
    private static final String PLANT_PREFIX = "plant";
    final AbstractPlantSetProperties field_235684_aB_;

    BlockPlant(PlantSet<?, ?> parentSet) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c).func_200944_c().func_200943_b(0.0f).func_200942_a(), parentSet.getSetTypeName() + "_" + PLANT_PREFIX + "_" + parentSet.getSetName());
        this.field_235684_aB_ = parentSet.getPlantSetProperties();
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)this.getGrowthProperty(), (Comparable)Integer.valueOf(0)));
    }

    private boolean isValidGround(BlockState state) {
        return state.func_177230_c() == ResynthBlocks.BLOCK_MINERAL_SOIL;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (!this.isValidGround(world.func_180495_p(pos.func_177977_b()))) {
            return false;
        }
        if (world.func_175710_j(pos)) {
            return true;
        }
        return world.func_205049_d(pos, 0) >= 4;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.isValidGround(worldIn.func_180495_p(currentPos.func_177977_b())) ? super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos) : Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_220074_n(BlockState state) {
        return false;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeByAge()[(Integer)state.func_177229_b((Property)this.getGrowthProperty())];
    }

    public static RenderType getResynthPlantRenderType() {
        return RenderType.func_228641_d_();
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EffectsUtil.displayStandardEffectsWithChance(worldIn, pos, 1, 5.0f, (IParticleData)ParticleTypes.field_197601_L);
    }

    protected boolean attemptAutoHarvest(int growth, World world, BlockPos pos) {
        if (ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).isHopperAutoFarmingEnabled() && growth >= this.getMaxGrowthStage() && this.tryHopperProduce(world, pos)) {
            EffectsUtil.displayStandardEffectsOnClient(pos, 3, (IParticleData)ParticleTypes.field_197598_I);
            return true;
        }
        return false;
    }

    private HopperTileEntity getHopper(World world, BlockPos pos) {
        BlockPos posA = pos.func_177979_c(2);
        BlockPos posB = posA.func_177979_c(1);
        TileEntity a = world.func_175625_s(posA);
        if (a instanceof HopperTileEntity) {
            return (HopperTileEntity)a;
        }
        a = world.func_175625_s(posB);
        if (a instanceof HopperTileEntity) {
            return (HopperTileEntity)a;
        }
        return null;
    }

    private boolean hasHopper(World world, BlockPos pos) {
        return this.getHopper(world, pos) != null;
    }

    private boolean tryHopperProduce(World world, BlockPos pos) {
        HopperTileEntity hopper = this.getHopper(world, pos);
        ItemStack produce = this.getProduce();
        if (hopper == null) {
            return false;
        }
        for (int i = 0; i <= 4; ++i) {
            int newCount;
            ItemStack occupied = hopper.func_70301_a(i);
            if (occupied.func_77973_b() == produce.func_77973_b() && (newCount = produce.func_190916_E() + occupied.func_190916_E()) <= 64) {
                ItemStack combinedProduce = new ItemStack((IItemProvider)produce.func_77973_b(), newCount);
                hopper.func_70299_a(i, combinedProduce);
                return true;
            }
            if (occupied != ItemStack.field_190927_a && occupied.func_77973_b() != Items.field_190931_a && occupied.func_190916_E() != 0) continue;
            hopper.func_70299_a(i, produce);
            return true;
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.attemptHarvest(world, pos, player) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    private boolean attemptHarvest(World world, BlockPos pos, PlayerEntity player) {
        if (this.getPostHarvestGrowthStage() == -1 || this.getHarvestProduceQuantity() == -1 || this.getSoundEventOfHarvest() == null) {
            return false;
        }
        int growth = (Integer)world.func_180495_p(pos).func_177229_b((Property)this.getGrowthProperty());
        int postHarvestGrowth = this.getPostHarvestGrowthStage();
        if (growth >= ((BlockPlant)world.func_180495_p(pos).func_177230_c()).getMaxGrowthStage() && this.setGrowthStage(world, pos, postHarvestGrowth)) {
            if (!world.field_72995_K) {
                MinecraftUtil.spawnItemStackInWorld(new ItemStack((IItemProvider)this.getProduce().func_77973_b(), this.getHarvestProduceQuantity()), world, pos);
            }
            EffectsUtil.playNormalSoundWithRandomPitch(world, player, pos, this.getSoundEventOfHarvest(), SoundCategory.BLOCKS);
            return true;
        }
        return false;
    }

    public void growPlantWithProbability(BlockState state, IWorld world, BlockPos pos) {
        if (!(world instanceof World)) {
            field_196273_d.error("IWorld not a World object!", (Throwable)new IllegalArgumentException());
        } else {
            this.growPlantFromProbability((World)world, state, pos);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.growPlantWithProbability(state, (IWorld)world, pos);
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    private boolean isFullyGrown(BlockState state) {
        return this.getGrowthStage(state) >= this.getMaxGrowthStage();
    }

    private int getGrowthFromBonemeal(Random random) {
        return MathUtil.getRandomIntegerInRange(random, 1, 3);
    }

    private boolean isGrowthPossible(World world, BlockPos pos) {
        if (!world.isAreaLoaded(pos, 1)) {
            return false;
        }
        return !this.isFullyGrown(world.func_180495_p(pos));
    }

    private float getMineralContent(World world, BlockPos pos) {
        TileEntityMineralSoil te = null;
        if (world.func_175625_s(pos.func_177977_b()) instanceof TileEntityMineralSoil) {
            te = (TileEntityMineralSoil)world.func_175625_s(pos.func_177977_b());
        }
        return te == null ? 0.0f : te.getMineralPercentage();
    }

    private float getMineralEnhancement(World world, BlockPos pos) {
        BlockState enhancer = world.func_180495_p(pos.func_177977_b().func_177977_b());
        if (enhancer.func_177230_c() instanceof BlockEnhancer) {
            return ((BlockEnhancer)enhancer.func_177230_c()).getIncrease();
        }
        return 0.0f;
    }

    private float getPlantBaseGrowthChance() {
        return this.field_235684_aB_.growthProbability();
    }

    public int getGrowthStage(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getGrowthProperty());
    }

    protected boolean setGrowthStage(World world, BlockPos pos, int growthStage) {
        return world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_177230_c().func_176223_P().func_206870_a((Property)this.getGrowthProperty(), (Comparable)Integer.valueOf(growthStage)), 2);
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return this.field_235684_aB_.bonemealGrowth() && !this.isFullyGrown(state);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return this.field_235684_aB_.bonemealGrowth();
    }

    public void func_225535_a_(ServerWorld world, Random random, BlockPos pos, BlockState state) {
        this.handlePlantGrowth((World)world, state, pos, this.getGrowthFromBonemeal(random));
    }

    abstract void onGrowPlantBlock(World var1, BlockState var2, BlockPos var3, int var4);

    private void growPlantFromProbability(World world, BlockState state, BlockPos pos) {
        MathUtil.Probability.newPercentageProbability(this.calculateChanceOfGrowth(world, state, pos)).randomResult().ifTrue(b -> {
            this.handlePlantGrowth(world, state, pos, 1);
            return null;
        });
    }

    private void growPlantBlock(World world, BlockState state, BlockPos pos, int increase) {
        if (this.isFullyGrown(world.func_180495_p(pos))) {
            return;
        }
        ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (boolean)false);
        this.onGrowPlantBlock(world, state, pos, increase);
        this.onPlantGrow(state, (IWorld)world, pos.func_177977_b(), pos);
        ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
    }

    private void handlePlantGrowth(World world, BlockState state, BlockPos pos, int increase) {
        int growth = this.getGrowthStage(state);
        if (this.isFullyGrown(state)) {
            if (this.attemptAutoHarvest(growth, world, pos)) {
                this.setGrowthStage(world, pos, this.getPostHarvestGrowthStage());
            }
            return;
        }
        if (!this.isGrowthPossible(world, pos)) {
            return;
        }
        this.growPlantBlock(world, state, pos, increase);
        if (this.attemptAutoHarvest(growth, world, pos)) {
            this.setGrowthStage(world, pos, this.getPostHarvestGrowthStage());
        }
    }

    private double calculateChanceOfGrowth(World world, BlockState state, BlockPos pos) {
        double baseGrowth = this.getPlantBaseGrowthChance();
        double soilModifier = this.getSoilGrowthModifier(world, pos);
        double enhancedSoilModifier = this.applyEnhancerModifier(world, pos, soilModifier);
        double growthRate = enhancedSoilModifier * baseGrowth;
        return this.applyLightingModifier(world, pos, growthRate);
    }

    private double applyLightingModifier(World world, BlockPos pos, double in) {
        if (!GENERAL_CONFIG.isGrowthLightDependent()) {
            return in;
        }
        double lightModifier = this.getLightGrowthModifier(world, pos);
        return lightModifier * in;
    }

    private double applyEnhancerModifier(World world, BlockPos pos, double in) {
        double enhancerModifier = this.getEnhancerModifier(world, pos);
        if (in >= 0.5 && enhancerModifier != 0.0) {
            return enhancerModifier + in;
        }
        return in;
    }

    private double getLightGrowthModifier(World world, BlockPos pos) {
        return this.lightLevelToGrowthMultiplier(this.getPlantLightLevel(world, pos), world.func_201572_C());
    }

    private double getSoilGrowthModifier(World world, BlockPos pos) {
        return this.getMineralContent(world, pos) / 100.0f;
    }

    private double getEnhancerModifier(World world, BlockPos pos) {
        return this.getMineralEnhancement(world, pos) / 100.0f;
    }

    public int getLightLevelZeroPoint() {
        return GENERAL_CONFIG.getLightLevelZeroPoint();
    }

    public double getWorthPerLightLevel() {
        return GENERAL_CONFIG.getWorthPerLightLevel();
    }

    public double getInterestPerLightLevel() {
        return GENERAL_CONFIG.getInterestPerLightLevel();
    }

    public int getPlantLightLevel(World world, BlockPos pos) {
        if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockPlant)) {
            return 0;
        }
        return world.func_201696_r(pos);
    }

    public double lightLevelToGrowthMultiplier(int lightLevel, int maxLightLevel) {
        return this.lightLevelToGrowthMultiplier(lightLevel, maxLightLevel, this.getLightLevelZeroPoint(), this.getWorthPerLightLevel(), this.getInterestPerLightLevel());
    }

    public double lightLevelToGrowthMultiplier(int lightLevel, int maxLightLevel, int zeroPoint, double cost, double interest) {
        double multiplier = 1.0;
        int difference = lightLevel - zeroPoint;
        if (difference > 0) {
            while (difference != 0) {
                multiplier += (cost += interest);
                --difference;
            }
        }
        if (difference < 0) {
            while (difference != 0) {
                multiplier -= (cost += interest);
                ++difference;
            }
        }
        return Math.max(multiplier, 0.0);
    }

    public void func_220062_a(BlockState state, ServerWorld world, BlockPos pos, ItemStack stack) {
        MinecraftUtil.spawnItemInWorld(this.getSeedsItem(), (World)world, pos);
        if (this.getGrowthStage(state) == this.getMaxGrowthStage() && this.dropsProduceWhenGrown() && this.getProduce() != null) {
            MinecraftUtil.spawnItemStackInWorld(this.getProduce(), (World)world, pos);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.getSeedsItem());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.getGrowthProperty()});
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.CROP;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        int stage = this.getGrowthStage(blockState);
        int max = this.getMaxGrowthStage();
        int percent = (int)((float)stage / (float)max * 100.0f);
        probeInfo.text((ITextComponent)new StringTextComponent(""));
        probeInfo.text((ITextComponent)new StringTextComponent(String.format(TextFormatting.GREEN.toString() + "G: %s / %s %s", stage, max, TextFormatting.DARK_GREEN + "(" + percent + "%)")));
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (tooltip.isEmpty()) {
            int stage = this.getGrowthStage(accessor.getWorld().func_180495_p(accessor.getPosition()));
            int max = this.getMaxGrowthStage();
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new StringTextComponent(BlockPlant.getGrowthStageMessage(stage, max) + String.format("  (%s%%)", (int)((float)stage / (float)max * 100.0f))));
            tooltip.add((ITextComponent)new StringTextComponent(""));
        }
    }

    private static String getGrowthStageMessage(int growthStage, int max) {
        return TextFormatting.GREEN + I18n.func_135052_a((String)"misc.resynth.growth_stage", (Object[])new Object[]{TextFormatting.GOLD + (growthStage + 1) + "/" + (max + 1)});
    }

    @Override
    public boolean provideHoeInformation(Map<String, Object[]> information, BlockState state, World world, BlockPos pos) {
        information.put("plant_info_header", new Object[]{TextFormatting.GRAY, TextFormatting.RED, TextFormatting.GRAY});
        int growthStage = this.getGrowthStage(world.func_180495_p(pos));
        information.put("plant_growth", new Object[]{TextFormatting.GREEN, TextFormatting.GOLD, growthStage, TextFormatting.DARK_GREEN, TextFormatting.GOLD, this.getMaxGrowthStage(), TextFormatting.DARK_GREEN});
        information.put("base_growth_rate", new Object[]{TextFormatting.DARK_PURPLE, TextFormatting.GOLD, Float.valueOf(this.getPlantBaseGrowthChance())});
        double total = this.applyEnhancerModifier(world, pos, this.getSoilGrowthModifier(world, pos)) * 100.0;
        information.put("soil_growth_modifier", new Object[]{TextFormatting.AQUA, TextFormatting.GOLD, MathUtil.roundToNDecimals(total, 3)});
        boolean useLight = GENERAL_CONFIG.isGrowthLightDependent();
        double lightMultiplier = this.lightLevelToGrowthMultiplier(this.getPlantLightLevel(world, pos), world.func_201572_C());
        information.put("light_growth_modifier", new Object[]{TextFormatting.YELLOW.toString() + (!useLight ? TextFormatting.STRIKETHROUGH.toString() : ""), TextFormatting.GOLD.toString() + (!useLight ? TextFormatting.STRIKETHROUGH.toString() : ""), (int)(lightMultiplier * 100.0)});
        double growthChance = total / 100.0 * (double)(this.getPlantBaseGrowthChance() / 100.0f) * 100.0;
        double lightBasedGrowthChance = lightMultiplier * (growthChance / 100.0) * 100.0;
        information.put("plant_growth_rate", new Object[]{TextFormatting.BLUE, TextFormatting.GOLD, MathUtil.roundToNDecimals(useLight ? lightBasedGrowthChance : growthChance, 3), TextFormatting.DARK_BLUE});
        information.put("footer", new Object[]{TextFormatting.GRAY});
        return true;
    }

    public AbstractPlantSetProperties getProperties() {
        return this.field_235684_aB_;
    }

    abstract IntegerProperty getGrowthProperty();

    abstract VoxelShape[] getShapeByAge();

    public abstract int getMaxGrowthStage();

    abstract boolean dropsProduceWhenGrown();

    protected abstract ItemSeeds getSeedsItem();

    protected abstract ItemStack getProduce();

    protected int getPostHarvestGrowthStage() {
        return -1;
    }

    protected int getHarvestProduceQuantity() {
        return -1;
    }

    protected SoundEvent getSoundEventOfHarvest() {
        return null;
    }
}

