/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.plant.block.BlockBiochemicalPlant;
import com.ki11erwolf.resynth.plant.item.ItemBulb;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetAPI;
import com.ki11erwolf.resynth.plant.set.PlantSetSeedHooks;
import com.ki11erwolf.resynth.plant.set.properties.AbstractBiochemicalProperties;
import com.ki11erwolf.resynth.util.MathUtil;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

abstract class BiochemicalSet
extends PlantSet<BlockBiochemicalPlant, EntityType<?>> {
    private static final String SET_TYPE_NAME = "biochemical";
    private static final SeedHooks SEED_HOOKS = new SeedHooks();
    private final AbstractBiochemicalProperties setProperties;

    BiochemicalSet(String setName, AbstractBiochemicalProperties properties) {
        super(SET_TYPE_NAME, setName, SEED_HOOKS, properties);
        this.setProperties = properties;
        this.produceItem = new ItemBulb(this);
        this.plantBlock = new BlockBiochemicalPlant(this){

            @Override
            protected ItemSeeds getSeedsItem() {
                return BiochemicalSet.this.seedsItem;
            }

            @Override
            protected ItemStack getProduce() {
                return new ItemStack((IItemProvider)BiochemicalSet.this.produceItem.func_199767_j(), BiochemicalSet.this.setProperties.plantYield());
            }
        };
        this.seedsItem = new ItemSeeds(this);
    }

    private static class SeedHooks
    extends PlantSetSeedHooks {
        private SeedHooks() {
        }

        @SubscribeEvent
        public void onEntityKilled(LivingDeathEvent event) {
            for (PlantSet<?, ?> set : PlantSetAPI.getSetsByType(PlantSetAPI.SetType.BIOCHEMICAL)) {
                ResourceLocation deadEntity = event.getEntity().func_200600_R().getRegistryName();
                BiochemicalSet plantSet = (BiochemicalSet)set;
                if (set.isBroken() || ((EntityType[])set.getSeedSources(EntityType[].class)).length == 0) continue;
                for (EntityType entity : (EntityType[])plantSet.getSeedSources(EntityType[].class)) {
                    ResourceLocation loopedEntity = entity.getRegistryName();
                    if (loopedEntity == null || !loopedEntity.equals((Object)deadEntity) || event.getEntity().func_130014_f_().field_72995_K || MathUtil.Probability.newPercentageProbability(plantSet.setProperties.seedSpawnChanceFromMob()).randomResult().isFalse()) continue;
                    SeedHooks.dropSeeds(set.getSeedsItem(), event.getEntity().func_130014_f_(), new BlockPos(event.getEntity().func_213303_ch()));
                }
            }
        }

        @SubscribeEvent
        public void onItemDestroyed(PlayerDestroyItemEvent event) {
            if (event.getOriginal() == null) {
                return;
            }
            for (PlantSet<?, ?> set : PlantSetAPI.getSetsByType(PlantSetAPI.SetType.BIOCHEMICAL)) {
                if (set.isBroken()) continue;
                BiochemicalSet plantSet = (BiochemicalSet)set;
                if (event.getOriginal().func_77973_b() != plantSet.getProduceItem().func_199767_j() || !MathUtil.Probability.newPercentageProbability(plantSet.setProperties.seedSpawnChanceFromBulb()).randomResult().isTrue() || event.getEntity().func_130014_f_().field_72995_K) continue;
                SeedHooks.dropSeeds(plantSet.getSeedsItem(), event.getEntity().func_130014_f_(), new BlockPos(event.getEntity().func_213303_ch()));
            }
        }
    }
}

