/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.plant.block.BlockCrystallinePlant;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.item.ItemShard;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetAPI;
import com.ki11erwolf.resynth.plant.set.PlantSetSeedHooks;
import com.ki11erwolf.resynth.plant.set.properties.AbstractCrystallineProperties;
import com.ki11erwolf.resynth.util.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

abstract class CrystallineSet
extends PlantSet<BlockCrystallinePlant, Block> {
    private static final String SET_TYPE_NAME = "crystalline";
    private static final SeedHooks SEED_HOOKS = new SeedHooks();
    private final AbstractCrystallineProperties setProperties;

    CrystallineSet(String setName, AbstractCrystallineProperties properties) {
        super(SET_TYPE_NAME, setName, SEED_HOOKS, properties);
        this.setProperties = properties;
        this.produceItem = new ItemShard(this);
        this.plantBlock = new BlockCrystallinePlant(this){

            @Override
            protected ItemSeeds getSeedsItem() {
                return CrystallineSet.this.seedsItem;
            }

            @Override
            protected ItemStack getProduce() {
                return new ItemStack((IItemProvider)CrystallineSet.this.produceItem.func_199767_j(), CrystallineSet.this.setProperties.plantYield());
            }
        };
        this.seedsItem = new ItemSeeds(this);
    }

    private static class SeedHooks
    extends PlantSetSeedHooks {
        private SeedHooks() {
        }

        @SubscribeEvent
        public void onBlockBroken(BlockEvent.BreakEvent event) {
            if (event.getPlayer() == null || event.getPlayer().func_184812_l_()) {
                return;
            }
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            IWorld world = event.getWorld();
            for (PlantSet<?, ?> set : PlantSetAPI.getSetsByType(PlantSetAPI.SetType.CRYSTALLINE)) {
                CrystallineSet crystallineSet;
                float spawnChance;
                if (set.isBroken() || ((Block[])set.getSeedSources(Block[].class)).length == 0 || (spawnChance = (crystallineSet = (CrystallineSet)set).setProperties.seedSpawnChanceFromOre()) < 0.0f || block != Block.func_149634_a((Item)((Block[])crystallineSet.getSeedSources(Block[].class))[0].func_199767_j()) || !MathUtil.Probability.newPercentageProbability(spawnChance).randomResult().isTrue()) continue;
                SeedHooks.dropSeeds(crystallineSet.seedsItem, (World)world, event.getPos());
                event.setCanceled(true);
                world.func_180501_a(event.getPos(), Blocks.field_150350_a.func_176223_P(), 2);
            }
        }

        @SubscribeEvent
        public void onItemExpire(ItemExpireEvent event) {
            Item i = event.getEntityItem().func_92059_d().func_77973_b();
            World world = event.getEntityItem().field_70170_p;
            BlockPos pos = new BlockPos(event.getEntityItem().func_213303_ch());
            int count = event.getEntityItem().func_92059_d().func_190916_E();
            Block b = world.func_180495_p(pos).func_177230_c();
            if (b != Blocks.field_150355_j) {
                return;
            }
            for (PlantSet<?, ?> set : PlantSetAPI.getSetsByType(PlantSetAPI.SetType.CRYSTALLINE)) {
                float spawnChance;
                if (set.isBroken() || ((Block[])set.getSeedSources(Block[].class)).length == 0 || i != set.getProduceItem().func_199767_j() || (spawnChance = ((CrystallineSet)set).setProperties.seedSpawnChanceFromShard()) < 0.0f) continue;
                for (int j = 0; j < count; ++j) {
                    if (!MathUtil.Probability.newPercentageProbability(spawnChance).randomResult().isTrue()) continue;
                    SeedHooks.dropSeeds(set.getSeedsItem(), world, pos);
                }
                return;
            }
        }
    }
}

