/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.plant.block.BlockMetallicPlant;
import com.ki11erwolf.resynth.plant.block.BlockOrganicOre;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetAPI;
import com.ki11erwolf.resynth.plant.set.PlantSetSeedHooks;
import com.ki11erwolf.resynth.plant.set.properties.AbstractMetallicProperties;
import com.ki11erwolf.resynth.util.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

abstract class MetallicSet
extends PlantSet<BlockMetallicPlant, Block> {
    private static final String SET_TYPE_NAME = "metallic";
    private static final SeedHooks SEED_HOOKS = new SeedHooks();
    private final AbstractMetallicProperties properties;

    MetallicSet(String setName, AbstractMetallicProperties properties) {
        super(SET_TYPE_NAME, setName, SEED_HOOKS, properties);
        this.properties = properties;
        this.produceItem = new BlockOrganicOre(this);
        this.plantBlock = new BlockMetallicPlant(this){

            @Override
            protected ItemSeeds getSeedsItem() {
                return MetallicSet.this.seedsItem;
            }

            @Override
            protected ItemStack getProduce() {
                return new ItemStack((IItemProvider)MetallicSet.this.produceItem.func_199767_j(), 1);
            }
        };
        this.seedsItem = new ItemSeeds(this);
    }

    private static class SeedHooks
    extends PlantSetSeedHooks {
        private SeedHooks() {
        }

        @SubscribeEvent
        public void onExplosion(ExplosionEvent.Detonate detonateEvent) {
            World world = detonateEvent.getWorld();
            for (BlockPos pos : detonateEvent.getAffectedBlocks()) {
                BlockState block = world.func_180495_p(pos);
                for (PlantSet<?, ?> set : PlantSetAPI.getSetsByType(PlantSetAPI.SetType.METALLIC)) {
                    if (set.isBroken() || ((Block[])set.getSeedSources(Block[].class)).length == 0) continue;
                    float chance = 0.0f;
                    if (block.func_177230_c() == Block.func_149634_a((Item)((Block[])set.getSeedSources(Block[].class))[0].func_199767_j())) {
                        chance = ((MetallicSet)set).properties.seedSpawnChanceFromOre();
                    } else if ((block.func_177230_c().getRegistryName() != null || set.getProduceItem().func_199767_j().getRegistryName() != null) && block.func_177230_c().getRegistryName().equals((Object)set.getProduceItem().func_199767_j().getRegistryName())) {
                        chance = ((MetallicSet)set).properties.seedSpawnChanceFromOrganicOre();
                    }
                    if (!MathUtil.Probability.newPercentageProbability(chance).randomResult().isTrue()) continue;
                    SeedHooks.dropSeeds(set.getSeedsItem(), world, pos);
                }
            }
        }
    }
}

