/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.analytics.PlantSetFailureEvent;
import com.ki11erwolf.resynth.analytics.ResynthAnalytics;
import com.ki11erwolf.resynth.plant.block.BlockPlant;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.set.PlantSetRegistry;
import com.ki11erwolf.resynth.plant.set.PlantSetSeedHooks;
import com.ki11erwolf.resynth.plant.set.properties.AbstractPlantSetProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractProduceProperties;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public abstract class PlantSet<P extends BlockPlant<?>, S extends IForgeRegistryEntry<?>> {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private final String setName;
    private final String setTypeName;
    private final AbstractPlantSetProperties basicPlantSetProperties;
    private AbstractProduceProperties produceProperties;
    private boolean isFailure;
    private S[] cachedSeedSources;
    private Optional<AbstractPlantSetProperties> serverPlantSetProperties = Optional.empty();
    private Optional<AbstractProduceProperties> serverPlantSetProduceProperties = Optional.empty();
    P plantBlock;
    ItemSeeds seedsItem;
    IItemProvider produceItem;

    PlantSet(String setTypeName, String setName, PlantSetSeedHooks seedHooks, AbstractPlantSetProperties properties) {
        this.setTypeName = Objects.requireNonNull(setTypeName);
        this.setName = Objects.requireNonNull(setName);
        this.basicPlantSetProperties = Objects.requireNonNull(properties);
        seedHooks.register();
    }

    abstract S[] onSeedSourcesRequest() throws Exception;

    void initSeedResources() throws IllegalStateException {
        this.cacheSeedSources();
    }

    S[] getSeedSources() {
        if (this.isBroken()) {
            return null;
        }
        return this.cachedSeedSources;
    }

    <T extends IForgeRegistryEntry<?>> T[] getSeedSources(Class<T[]> t) {
        IForgeRegistryEntry[] seedSources = this.getSeedSources();
        if (seedSources == null) {
            return (IForgeRegistryEntry[])t.cast(Array.newInstance(t.getComponentType(), 0));
        }
        return (IForgeRegistryEntry[])t.cast(seedSources);
    }

    private void cacheSeedSources() throws IllegalStateException {
        if (this.cachedSeedSources != null) {
            throw new IllegalStateException("Cannot load seed sources because the cache has already been created.");
        }
        if (this.isBroken()) {
            LOG.error("Cannot load seed sources for the PlantSet '" + this.getSetName() + "' which has been flagged as broken!");
            this.cachedSeedSources = null;
            return;
        }
        this.cachedSeedSources = this.loadSeedSources();
    }

    private S[] loadSeedSources() {
        IForgeRegistryEntry[] givenSeedSources = null;
        try {
            givenSeedSources = this.onSeedSourcesRequest();
        }
        catch (Exception e) {
            LOG.error(String.format("PlantSet '%s' throw exception when getting seed resources", this.getSetName()), (Throwable)e);
        }
        if (this.checkSeedSources(givenSeedSources)) {
            return givenSeedSources;
        }
        this.flagAsBroken();
        return null;
    }

    private boolean checkSeedSources(S[] seedSources) {
        if (seedSources == null || seedSources.length == 0) {
            LOG.error("Got null or empty list of seed resources from PlantSet '" + this.getSetName() + "'.");
            return false;
        }
        if (Arrays.stream(seedSources).anyMatch(Objects::isNull)) {
            LOG.error(String.format("PlantSet '%s' provided list of one or more null seed sources.", this.getSetName()));
            return false;
        }
        return true;
    }

    void flagAsBroken() {
        if (this.isFailure) {
            return;
        }
        this.isFailure = true;
        ResynthAnalytics.send(new PlantSetFailureEvent(this.setName));
    }

    void setProduceProperties(AbstractProduceProperties properties) {
        this.produceProperties = Objects.requireNonNull(properties);
    }

    public boolean isBroken() {
        return this.isFailure;
    }

    public String getSetTypeName() {
        return this.setTypeName;
    }

    public String getSetName() {
        return this.setName;
    }

    public P getPlantBlock() {
        return this.plantBlock;
    }

    public IItemProvider getProduceItem() {
        return this.produceItem;
    }

    public ItemSeeds getSeedsItem() {
        return this.seedsItem;
    }

    public AbstractPlantSetProperties getPlantSetProperties() {
        return this.basicPlantSetProperties;
    }

    public AbstractProduceProperties getProduceProperties() {
        return this.produceProperties;
    }

    public Optional<AbstractPlantSetProperties> serverPlantSetProperties() {
        return this.serverPlantSetProperties;
    }

    public Optional<AbstractProduceProperties> serverPlantSetProduceProperties() {
        return this.serverPlantSetProduceProperties;
    }

    protected void setServerPlantSetProperties(AbstractPlantSetProperties serverPlantSetProperties) {
        this.serverPlantSetProperties = Optional.of(serverPlantSetProperties);
    }

    protected void setServerPlantSetProduceProperties(AbstractProduceProperties serverPlantSetProduceProperties) {
        this.serverPlantSetProduceProperties = Optional.of(serverPlantSetProduceProperties);
    }

    protected void clearServerPlantSetProperties() {
        this.serverPlantSetProperties = Optional.empty();
    }

    protected void clearServerPlantSetProduceProperties() {
        this.serverPlantSetProduceProperties = Optional.empty();
    }

    public String toString() {
        return String.format("PlantSet[type=%s, name=%s, failure=%s]", this.getSetTypeName(), this.getSetName(), this.isBroken());
    }

    public PlantSet<P, S> register() {
        PlantSetRegistry.registerPlantSet(this);
        return this;
    }
}

