/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.ResynthRecipes;
import com.ki11erwolf.resynth.plant.set.BiochemicalSet;
import com.ki11erwolf.resynth.plant.set.CrystallineSet;
import com.ki11erwolf.resynth.plant.set.MetallicSet;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetRecipes;
import com.ki11erwolf.resynth.plant.set.PlantSetRegistry;
import com.ki11erwolf.resynth.plant.set.PropertiesSynchronizer;
import com.ki11erwolf.resynth.plant.set.properties.AbstractPlantSetProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractProduceProperties;
import java.util.Objects;
import java.util.function.Function;

public class PlantSetAPI {
    private PlantSetAPI() {
    }

    public static void foreachSet(SetType setType, Function<PlantSet<?, ?>, Void> action) {
        PlantSetRegistry.streamPlantSets().filter(setType::matches).forEach(action::apply);
    }

    public static PlantSet<?, ?>[] getSetsByType(SetType setType) {
        return (PlantSet[])PlantSetRegistry.streamPlantSets().filter(setType::matches).toArray(PlantSet[]::new);
    }

    public static PlantSet<?, ?> getSetByName(String name) {
        return PlantSetRegistry.streamPlantSets().filter(set -> set.getSetName().equals(Objects.requireNonNull(name))).findFirst().orElse(null);
    }

    public static ResynthRecipes.RecipeProvider getPlantSetRecipes() {
        return PlantSetRecipes.INSTANCE;
    }

    public static void synchronizePlantSetProperties(String setName, AbstractPlantSetProperties properties, AbstractProduceProperties produceProperties) {
        PropertiesSynchronizer.INSTANCE.handlePropertiesSynchronizing(Objects.requireNonNull(setName), Objects.requireNonNull(properties), Objects.requireNonNull(produceProperties));
    }

    public static enum SetType {
        BIOCHEMICAL{

            @Override
            public boolean matches(PlantSet<?, ?> set) {
                return set instanceof BiochemicalSet;
            }
        }
        ,
        CRYSTALLINE{

            @Override
            public boolean matches(PlantSet<?, ?> set) {
                return set instanceof CrystallineSet;
            }
        }
        ,
        METALLIC{

            @Override
            public boolean matches(PlantSet<?, ?> set) {
                return set instanceof MetallicSet;
            }
        }
        ,
        ALL{

            @Override
            public boolean matches(PlantSet<?, ?> set) {
                return set != null;
            }
        };


        public abstract boolean matches(PlantSet<?, ?> var1);
    }
}

