/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.config.ConfigFile;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.BiochemicalPropertiesConfig;
import com.ki11erwolf.resynth.config.categories.CrystallinePropertiesConfig;
import com.ki11erwolf.resynth.config.categories.MetallicPropertiesConfig;
import com.ki11erwolf.resynth.config.categories.ProducePropertiesConfig;
import com.ki11erwolf.resynth.plant.block.BlockBiochemicalPlant;
import com.ki11erwolf.resynth.plant.block.BlockCrystallinePlant;
import com.ki11erwolf.resynth.plant.block.BlockMetallicPlant;
import com.ki11erwolf.resynth.plant.set.BiochemicalSet;
import com.ki11erwolf.resynth.plant.set.CrystallineSet;
import com.ki11erwolf.resynth.plant.set.MetallicSet;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetRecipes;
import com.ki11erwolf.resynth.plant.set.properties.AbstractBiochemicalProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractCrystallineProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractMetallicProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractProduceProperties;
import com.ki11erwolf.resynth.plant.set.properties.BiochemicalProperties;
import com.ki11erwolf.resynth.plant.set.properties.CrystallineProperties;
import com.ki11erwolf.resynth.plant.set.properties.MetallicProperties;
import com.ki11erwolf.resynth.plant.set.properties.ProduceProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class PlantSetFactory {
    private static final Logger LOG = ResynthMod.getNewLogger();

    private PlantSetFactory() {
    }

    public static PlantSet<? extends BlockCrystallinePlant, Block> makeCrystallineSet(ResourceLocation id, CrystallineProperties defaultConfig, ProduceProperties defaultProduceConfig, ResourceLocation outputItemID, ResourceLocation ... oreBlockIDs) {
        return PlantSetFactory.createCrystallineSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), Objects.requireNonNull(defaultProduceConfig), PlantSetFactory.validate(outputItemID), Objects.requireNonNull(oreBlockIDs));
    }

    public static PlantSet<? extends BlockCrystallinePlant, Block> makeCrystallineSet(ResourceLocation id, CrystallineProperties defaultConfig, ProduceProperties produceConfig, IItemProvider outputItem, Block ... oreBlocks) {
        ArrayList<ResourceLocation> oreIDs = new ArrayList<ResourceLocation>();
        for (Block block : Objects.requireNonNull(oreBlocks)) {
            oreIDs.add(Objects.requireNonNull(block).getRegistryName());
        }
        return PlantSetFactory.createCrystallineSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), Objects.requireNonNull(produceConfig), Objects.requireNonNull(outputItem).func_199767_j().getRegistryName(), oreIDs.toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockCrystallinePlant, Block> makeCrystallineSet(ResourceLocation id, CrystallineProperties defaultConfig, ProduceProperties produceConfig, String outputItemName, String ... oreBlockNames) {
        ArrayList<ResourceLocation> oreIDs = new ArrayList<ResourceLocation>();
        for (String ore : Objects.requireNonNull(oreBlockNames)) {
            oreIDs.add(new ResourceLocation(id.func_110624_b(), Objects.requireNonNull(ore)));
        }
        return PlantSetFactory.createCrystallineSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), Objects.requireNonNull(produceConfig), new ResourceLocation(id.func_110624_b(), Objects.requireNonNull(outputItemName)), ((List)Objects.requireNonNull(oreIDs)).toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockCrystallinePlant, Block> makeCrystallineSet(ResourceLocation id, CrystallineProperties defaultConfig, String ... oreBlockNames) {
        ArrayList<ResourceLocation> oreIDs = new ArrayList<ResourceLocation>();
        for (String ore : Objects.requireNonNull(oreBlockNames)) {
            oreIDs.add(new ResourceLocation(id.func_110624_b(), Objects.requireNonNull(ore)));
        }
        return PlantSetFactory.createCrystallineSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), oreIDs.toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockCrystallinePlant, Block> makeCrystallineSet(ResourceLocation id, CrystallineProperties defaultConfig, Block ... oreBlocks) {
        ArrayList<ResourceLocation> oreIDs = new ArrayList<ResourceLocation>();
        for (Block ore : Objects.requireNonNull(oreBlocks)) {
            oreIDs.add(ore.getRegistryName());
        }
        return PlantSetFactory.createCrystallineSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), oreIDs.toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockCrystallinePlant, Block> makeCrystallineSet(ResourceLocation id, CrystallineProperties defaultConfig, ResourceLocation ... oreBlockIDs) {
        return PlantSetFactory.createCrystallineSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), Objects.requireNonNull(oreBlockIDs));
    }

    public static PlantSet<? extends BlockMetallicPlant, Block> makeMetallicSet(ResourceLocation id, MetallicProperties defaultConfig, ProduceProperties produceConfig, ResourceLocation outputItemID, ResourceLocation ... oreBlockIDs) {
        return PlantSetFactory.createMetallicSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), Objects.requireNonNull(produceConfig), PlantSetFactory.validate(outputItemID), Objects.requireNonNull(oreBlockIDs));
    }

    public static PlantSet<? extends BlockMetallicPlant, Block> makeMetallicSet(ResourceLocation id, MetallicProperties defaultConfig, ProduceProperties produceConfig, IItemProvider outputItem, Block ... oreBlocks) {
        ArrayList<ResourceLocation> oreIDs = new ArrayList<ResourceLocation>();
        for (Block ore : Objects.requireNonNull(oreBlocks)) {
            oreIDs.add(ore.getRegistryName());
        }
        return PlantSetFactory.createMetallicSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), Objects.requireNonNull(produceConfig), Objects.requireNonNull(outputItem).func_199767_j().getRegistryName(), oreIDs.toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockMetallicPlant, Block> makeMetallicSet(ResourceLocation id, MetallicProperties defaultConfig, ProduceProperties produceConfig, String oreBlockName, String outputItemName) {
        return PlantSetFactory.createMetallicSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), Objects.requireNonNull(produceConfig), new ResourceLocation(id.func_110624_b(), Objects.requireNonNull(outputItemName)), new ResourceLocation(id.func_110624_b(), Objects.requireNonNull(oreBlockName)));
    }

    public static PlantSet<? extends BlockMetallicPlant, Block> makeMetallicSet(ResourceLocation id, MetallicProperties defaultConfig, String oreBlockName) {
        return PlantSetFactory.createMetallicSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), new ResourceLocation(id.func_110624_b(), Objects.requireNonNull(oreBlockName)));
    }

    public static PlantSet<? extends BlockMetallicPlant, Block> makeMetallicSet(ResourceLocation id, MetallicProperties defaultConfig, Block ... oreBlocks) {
        ArrayList<ResourceLocation> oreIDs = new ArrayList<ResourceLocation>();
        for (Block ore : Objects.requireNonNull(oreBlocks)) {
            oreIDs.add(ore.getRegistryName());
        }
        return PlantSetFactory.createMetallicSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), oreIDs.toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockMetallicPlant, Block> makeMetallicSet(ResourceLocation id, MetallicProperties defaultConfig, ResourceLocation ... oreBlockIDs) {
        return PlantSetFactory.createMetallicSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), Objects.requireNonNull(oreBlockIDs));
    }

    public static PlantSet<? extends BlockBiochemicalPlant, EntityType<?>> makeBiochemicalSet(ResourceLocation id, BiochemicalProperties defaultConfig, ResourceLocation outputItemID, ProduceProperties produceConfig, ResourceLocation ... entityIDs) {
        return PlantSetFactory.createBiochemicalSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), PlantSetFactory.validate(outputItemID), Objects.requireNonNull(produceConfig), Objects.requireNonNull(entityIDs));
    }

    public static PlantSet<? extends BlockBiochemicalPlant, EntityType<?>> makeBiochemicalSet(ResourceLocation id, BiochemicalProperties defaultConfig, ProduceProperties produceConfig, IItemProvider outputItem, EntityType<?> ... entities) {
        ArrayList<ResourceLocation> entityIDs = new ArrayList<ResourceLocation>();
        for (EntityType<?> entity : Objects.requireNonNull(entities)) {
            entityIDs.add(Objects.requireNonNull(entity).getRegistryName());
        }
        return PlantSetFactory.createBiochemicalSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), Objects.requireNonNull(outputItem).func_199767_j().getRegistryName(), Objects.requireNonNull(produceConfig), entityIDs.toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockBiochemicalPlant, EntityType<?>> makeBiochemicalSet(ResourceLocation id, BiochemicalProperties defaultConfig, ProduceProperties produceConfig, String outputItemName, String ... entityNames) {
        ArrayList<ResourceLocation> entityIDs = new ArrayList<ResourceLocation>();
        for (String entityName : Objects.requireNonNull(entityNames)) {
            entityIDs.add(new ResourceLocation(id.func_110624_b(), Objects.requireNonNull(entityName)));
        }
        return PlantSetFactory.createBiochemicalSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), new ResourceLocation(id.func_110624_b(), Objects.requireNonNull(outputItemName)), Objects.requireNonNull(produceConfig), entityIDs.toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockBiochemicalPlant, EntityType<?>> makeBiochemicalSet(ResourceLocation id, BiochemicalProperties defaultConfig, String ... entityNames) {
        ArrayList<ResourceLocation> entityIDs = new ArrayList<ResourceLocation>();
        for (String entityName : Objects.requireNonNull(entityNames)) {
            entityIDs.add(new ResourceLocation(id.func_110624_b(), Objects.requireNonNull(entityName)));
        }
        return PlantSetFactory.createBiochemicalSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), entityIDs.isEmpty() ? null : entityIDs.toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockBiochemicalPlant, EntityType<?>> makeBiochemicalSet(ResourceLocation id, BiochemicalProperties defaultConfig, EntityType<?> ... entities) {
        ArrayList<ResourceLocation> entityIDs = new ArrayList<ResourceLocation>();
        for (EntityType<?> entity : Objects.requireNonNull(entities)) {
            entityIDs.add(Objects.requireNonNull(entity).getRegistryName());
        }
        return PlantSetFactory.createBiochemicalSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), entityIDs.isEmpty() ? null : entityIDs.toArray(new ResourceLocation[0]));
    }

    public static PlantSet<? extends BlockBiochemicalPlant, EntityType<?>> makeBiochemicalSet(ResourceLocation id, BiochemicalProperties defaultConfig, ResourceLocation ... entityIDs) {
        for (ResourceLocation entityID : Objects.requireNonNull(entityIDs)) {
            PlantSetFactory.validate(entityID);
        }
        return PlantSetFactory.createBiochemicalSet(PlantSetFactory.validate(id), Objects.requireNonNull(defaultConfig), entityIDs);
    }

    private static PlantSet<? extends BlockCrystallinePlant, Block> createCrystallineSet(ResourceLocation id, CrystallineProperties config, ProduceProperties produceConfig, ResourceLocation outputItemID, ResourceLocation ... oreBlockIDs) {
        String setName;
        String string = setName = PlantSetFactory.isVanilla(id) ? id.func_110623_a() : PlantSetFactory.combine(id, '_');
        if (!PlantSetFactory.isParentLoaded(outputItemID)) {
            PlantSetFactory.logSkippedSet(setName, outputItemID.func_110624_b());
            return null;
        }
        PlantSet<? extends BlockCrystallinePlant, Block> plantSet = PlantSetFactory.createCrystallineSet(id, config, oreBlockIDs);
        if (plantSet == null) {
            return null;
        }
        ProducePropertiesConfig produceProperties = PlantSetFactory.getSetProduceConfig(id, produceConfig);
        plantSet.setProduceProperties(produceProperties);
        PlantSetRecipes.INSTANCE.addProduceRecipe(plantSet, outputItemID, produceProperties);
        int seedsRecipeCount = ((CrystallinePropertiesConfig)plantSet.getPlantSetProperties()).seedCraftingYield();
        if (seedsRecipeCount > 0) {
            seedsRecipeCount = Math.min(seedsRecipeCount, 64);
            PlantSetRecipes.INSTANCE.addCrystallineSeedsRecipe(plantSet, outputItemID, seedsRecipeCount);
        }
        return plantSet;
    }

    private static PlantSet<? extends BlockCrystallinePlant, Block> createCrystallineSet(ResourceLocation id, CrystallineProperties config, ResourceLocation ... oreBlockIDs) {
        String setName = PlantSetFactory.isVanilla(id) ? id.func_110623_a() : PlantSetFactory.combine(id, '_');
        String parentModID = id.func_110624_b();
        if (!PlantSetFactory.isParentLoaded(id)) {
            PlantSetFactory.logSkippedSet(setName, parentModID);
            return null;
        }
        for (ResourceLocation entityID : oreBlockIDs) {
            if (PlantSetFactory.isParentLoaded(entityID)) continue;
            PlantSetFactory.logSkippedSet(setName, entityID.func_110624_b());
            return null;
        }
        AbstractCrystallineProperties properties = PlantSetFactory.getCrystallineProperties(id, config);
        LOG.info(String.format("Creating Crystalline plant set: '%s' for mod: '%s'.", setName, parentModID));
        return PlantSetFactory.createNewCrystallineSet(setName, properties, oreBlockIDs);
    }

    private static AbstractCrystallineProperties getCrystallineProperties(ResourceLocation id, CrystallineProperties config) {
        boolean vanilla = PlantSetFactory.isVanilla(id);
        String setName = vanilla ? id.func_110623_a() : PlantSetFactory.combine(id, '-');
        ConfigFile configFile = vanilla ? ResynthConfig.VANILLA_PLANTS_CONFIG : ResynthConfig.MODDED_PLANTS_CONFIG;
        return configFile.loadCategory(new CrystallinePropertiesConfig(setName, config));
    }

    private static PlantSet<? extends BlockCrystallinePlant, Block> createNewCrystallineSet(final String name, AbstractCrystallineProperties config, final ResourceLocation ... oreBlockIDs) {
        return new CrystallineSet(name, config){

            Block[] onSeedSourcesRequest() {
                ArrayList<Block> ores = new ArrayList<Block>();
                for (ResourceLocation entityID : oreBlockIDs) {
                    Block ore = PlantSetFactory.getSetSeedBlock(this, entityID);
                    if (ore == null) {
                        throw new MissingResourceException(String.format("Could not get Crystalline seed source entity '%s' for the PlantSet '%s'", entityID.toString(), name), null, null);
                    }
                    ores.add(ore);
                }
                return ores.toArray(new Block[0]);
            }
        };
    }

    private static PlantSet<? extends BlockMetallicPlant, Block> createMetallicSet(ResourceLocation id, MetallicProperties config, ProduceProperties produceConfig, ResourceLocation outputItemID, ResourceLocation ... oreBlockIDs) {
        String setName;
        String string = setName = PlantSetFactory.isVanilla(id) ? id.func_110623_a() : PlantSetFactory.combine(id, '_');
        if (!PlantSetFactory.isParentLoaded(outputItemID)) {
            PlantSetFactory.logSkippedSet(setName, outputItemID.func_110624_b());
            return null;
        }
        PlantSet<? extends BlockMetallicPlant, Block> plantSet = PlantSetFactory.createMetallicSet(id, config, oreBlockIDs);
        if (plantSet == null) {
            return null;
        }
        ProducePropertiesConfig produceProperties = PlantSetFactory.getSetProduceConfig(id, produceConfig);
        plantSet.setProduceProperties(produceProperties);
        PlantSetRecipes.INSTANCE.addProduceRecipe(plantSet, outputItemID, produceProperties);
        return plantSet;
    }

    private static PlantSet<? extends BlockMetallicPlant, Block> createMetallicSet(ResourceLocation id, MetallicProperties config, ResourceLocation ... oreBlockIDs) {
        String setName = PlantSetFactory.isVanilla(id) ? id.func_110623_a() : PlantSetFactory.combine(id, '_');
        String parentModID = id.func_110624_b();
        if (!PlantSetFactory.isParentLoaded(id)) {
            PlantSetFactory.logSkippedSet(setName, parentModID);
            return null;
        }
        for (ResourceLocation entityID : oreBlockIDs) {
            if (PlantSetFactory.isParentLoaded(entityID)) continue;
            PlantSetFactory.logSkippedSet(setName, entityID.func_110624_b());
            return null;
        }
        AbstractMetallicProperties properties = PlantSetFactory.getMetallicProperties(id, config);
        LOG.info(String.format("Creating Metallic plant set: '%s' for mod: '%s'.", setName, parentModID));
        return PlantSetFactory.createNewMetallicSet(setName, properties, oreBlockIDs);
    }

    private static AbstractMetallicProperties getMetallicProperties(ResourceLocation id, MetallicProperties config) {
        boolean vanilla = PlantSetFactory.isVanilla(id);
        String setName = vanilla ? id.func_110623_a() : PlantSetFactory.combine(id, '-');
        ConfigFile configFile = vanilla ? ResynthConfig.VANILLA_PLANTS_CONFIG : ResynthConfig.MODDED_PLANTS_CONFIG;
        return configFile.loadCategory(new MetallicPropertiesConfig(setName, config));
    }

    private static PlantSet<? extends BlockMetallicPlant, Block> createNewMetallicSet(final String name, AbstractMetallicProperties config, final ResourceLocation ... oreBlockIDs) {
        return new MetallicSet(name, config){

            Block[] onSeedSourcesRequest() {
                ArrayList<Block> ores = new ArrayList<Block>();
                for (ResourceLocation entityID : oreBlockIDs) {
                    Block ore = PlantSetFactory.getSetSeedBlock(this, entityID);
                    if (ore == null) {
                        throw new MissingResourceException(String.format("Could not get Metallic seed source entity '%s' for the PlantSet '%s'", entityID.toString(), name), null, null);
                    }
                    ores.add(ore);
                }
                return ores.toArray(new Block[0]);
            }
        };
    }

    private static PlantSet<? extends BlockBiochemicalPlant, EntityType<?>> createBiochemicalSet(ResourceLocation id, BiochemicalProperties config, ResourceLocation outputItemID, ProduceProperties produceConfig, ResourceLocation ... entityIDs) {
        String setName;
        String string = setName = PlantSetFactory.isVanilla(id) ? id.func_110623_a() : PlantSetFactory.combine(id, '_');
        if (!PlantSetFactory.isParentLoaded(outputItemID)) {
            PlantSetFactory.logSkippedSet(setName, outputItemID.func_110624_b());
            return null;
        }
        PlantSet<BlockBiochemicalPlant, EntityType<?>> plantSet = PlantSetFactory.createBiochemicalSet(id, config, entityIDs);
        if (plantSet == null) {
            return null;
        }
        ProducePropertiesConfig produceProperties = PlantSetFactory.getSetProduceConfig(id, produceConfig);
        plantSet.setProduceProperties(produceProperties);
        PlantSetRecipes.INSTANCE.addProduceRecipe(plantSet, outputItemID, produceProperties);
        return plantSet;
    }

    private static PlantSet<? extends BlockBiochemicalPlant, EntityType<?>> createBiochemicalSet(ResourceLocation id, BiochemicalProperties config, ResourceLocation ... entityIDs) {
        String setName = PlantSetFactory.isVanilla(id) ? id.func_110623_a() : PlantSetFactory.combine(id, '_');
        String parentModID = id.func_110624_b();
        if (!PlantSetFactory.isParentLoaded(id)) {
            PlantSetFactory.logSkippedSet(setName, parentModID);
            return null;
        }
        for (ResourceLocation entityID : entityIDs) {
            if (PlantSetFactory.isParentLoaded(entityID)) continue;
            PlantSetFactory.logSkippedSet(setName, entityID.func_110624_b());
            return null;
        }
        BiochemicalPropertiesConfig properties = PlantSetFactory.getBiochemicalProperties(id, config);
        LOG.info(String.format("Creating Biochemical plant set: '%s' for mod: '%s'.", setName, parentModID));
        return PlantSetFactory.createNewBiochemicalSet(setName, properties, entityIDs);
    }

    private static BiochemicalPropertiesConfig getBiochemicalProperties(ResourceLocation id, BiochemicalProperties config) {
        boolean vanilla = PlantSetFactory.isVanilla(id);
        String setName = vanilla ? id.func_110623_a() : PlantSetFactory.combine(id, '-');
        ConfigFile configFile = vanilla ? ResynthConfig.VANILLA_PLANTS_CONFIG : ResynthConfig.MODDED_PLANTS_CONFIG;
        return configFile.loadCategory(new BiochemicalPropertiesConfig(setName, config));
    }

    private static PlantSet<? extends BlockBiochemicalPlant, EntityType<?>> createNewBiochemicalSet(final String name, AbstractBiochemicalProperties config, final ResourceLocation ... entityIDs) {
        return new BiochemicalSet(name, config){

            EntityType<?>[] onSeedSourcesRequest() {
                ArrayList<EntityType> tempEntities = new ArrayList<EntityType>();
                for (ResourceLocation entityID : entityIDs) {
                    EntityType entity = PlantSetFactory.getSetSeedEntity(this, entityID);
                    if (entity == null) {
                        throw new MissingResourceException(String.format("Could not get Biochemical seed source entity '%s' for the PlantSet '%s'", entityID.toString(), name), null, null);
                    }
                    tempEntities.add(entity);
                }
                return tempEntities.toArray(new EntityType[0]);
            }
        };
    }

    private static ProducePropertiesConfig getSetProduceConfig(ResourceLocation id, AbstractProduceProperties produceConfig) {
        boolean vanilla = PlantSetFactory.isVanilla(id);
        String categoryName = vanilla ? id.func_110623_a() : PlantSetFactory.combine(id, '-');
        ConfigFile configFile = vanilla ? ResynthConfig.VANILLA_PLANTS_CONFIG : ResynthConfig.MODDED_PLANTS_CONFIG;
        return configFile.loadCategory(new ProducePropertiesConfig(categoryName, produceConfig));
    }

    private static void logSkippedSet(String setName, String missingModID) {
        LOG.info(String.format("Skipping plant set '%s' because the required mod '%s' is not present.", setName, missingModID));
    }

    private static Block getSetSeedBlock(PlantSet<?, ?> set, ResourceLocation blockID) {
        Block ore = PlantSetFactory.getRegistryBlock(blockID);
        if (ore == null || ore == Blocks.field_150350_a) {
            LOG.error(String.format("Could not get the seed block '%s' for the plant set '%s'", blockID.toString(), set.toString()));
            return null;
        }
        return ore;
    }

    private static Block getRegistryBlock(ResourceLocation blockID) {
        Block block;
        if (ForgeRegistries.BLOCKS.containsKey(blockID) && (block = (Block)ForgeRegistries.BLOCKS.getValue(blockID)) != null && block != Blocks.field_150350_a) {
            return block;
        }
        return null;
    }

    private static EntityType<?> getSetSeedEntity(PlantSet<?, ?> set, ResourceLocation entityID) {
        EntityType<?> entity = PlantSetFactory.getRegistryEntity(entityID);
        if (entity == null || entity.func_220339_d() == EntityClassification.MISC) {
            LOG.error(String.format("Could not get the seed entity '%s' for the plant set '%s'", entityID.toString(), set.toString()));
            return null;
        }
        return entity;
    }

    private static EntityType<?> getRegistryEntity(ResourceLocation entityID) {
        if (ForgeRegistries.ENTITIES.containsKey(entityID)) {
            return (EntityType)ForgeRegistries.ENTITIES.getValue(entityID);
        }
        return null;
    }

    private static ResourceLocation validate(ResourceLocation id) throws NullPointerException, IllegalArgumentException {
        if (Objects.requireNonNull(id).func_110623_a().isEmpty()) {
            throw new IllegalArgumentException("Invalid ResourceLocation ID! The path cannot be empty");
        }
        return id;
    }

    private static String combine(ResourceLocation id, char separator) {
        return Objects.requireNonNull(id).func_110624_b() + separator + id.func_110623_a();
    }

    private static boolean isVanilla(ResourceLocation resourceLocation) {
        String namespace = Objects.requireNonNull(resourceLocation).func_110624_b();
        return namespace.isEmpty() || namespace.equals("minecraft") || namespace.equals("resynth");
    }

    private static boolean isParentLoaded(ResourceLocation plantSetID) {
        return PlantSetFactory.isVanilla(plantSetID) || ModList.get().isLoaded(plantSetID.func_110624_b());
    }
}

