/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.ResynthRecipes;
import com.ki11erwolf.resynth.plant.block.BlockCrystallinePlant;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.properties.AbstractProduceProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

enum PlantSetRecipes implements ResynthRecipes.RecipeProvider
{
    INSTANCE;

    private static final Logger LOG;
    private Queue<RecipeDefinition<?>> recipeDefinitions = new ArrayDeque();
    private IRecipe<?>[] finalRecipes;

    private void addRecipe(RecipeDefinition<?> recipe) {
        if (this.recipeDefinitions == null) {
            throw new IllegalStateException("Cannot add any more plant set recipes! The recipes have already been finalized");
        }
        this.recipeDefinitions.add(Objects.requireNonNull(recipe));
    }

    void addCrystallineSeedsRecipe(PlantSet<? extends BlockCrystallinePlant, Block> set, ResourceLocation outputItemID, int count) {
        String recipeType = set.getSetTypeName() + "-plant-set-seeds-to-resource";
        ResourceLocation recipeID = new ResourceLocation("resynth", set.getSetName() + "-" + recipeType);
        this.addRecipe(new ShapelessRecipeDefinition(set, recipeID, recipeType, outputItemID, 2, set.getSeedsItem().getRegistryName()));
    }

    void addProduceRecipe(PlantSet<?, ?> set, ResourceLocation outputItemID, AbstractProduceProperties properties) {
        this.addProduceRecipe(set, outputItemID, properties.produceYield(), properties.timePerYield(), properties.experiencePoints());
    }

    void addProduceRecipe(PlantSet<?, ?> set, ResourceLocation outputItemID, int count, int time, double experience) {
        ResourceLocation setProduce;
        String recipeType = set.getSetTypeName() + "-plant-set-produce-smelting";
        ResourceLocation recipeID = new ResourceLocation("resynth", set.getSetName() + "-" + recipeType);
        if (set.getProduceItem() instanceof Block) {
            setProduce = ((Block)set.getProduceItem()).getRegistryName();
        } else if (set.getProduceItem() instanceof Item) {
            setProduce = ((Item)set.getProduceItem()).getRegistryName();
        } else {
            throw new IllegalArgumentException("The PlantSet '" + set.getSetName() + "' provided an invalid produce item!");
        }
        this.addRecipe(new FurnaceRecipeDefinition(set, recipeID, recipeType, setProduce, outputItemID, count, experience, time));
    }

    @Override
    public IRecipe<?>[] get() {
        return this.getFinalRecipes();
    }

    private IRecipe<?>[] getFinalRecipes() {
        if (this.recipeDefinitions == null) {
            return this.finalRecipes;
        }
        return this.finalizeRecipes();
    }

    private IRecipe<?>[] finalizeRecipes() {
        IRecipe<?>[] recipes = this.initializeRecipes();
        this.recipeDefinitions = null;
        if (recipes == null) {
            LOG.warn("No defined plant set recipes have been added...");
        } else if (recipes.length == 0) {
            LOG.error("Zero recipes were initialized successfully...");
            this.finalRecipes = null;
            return null;
        }
        this.finalRecipes = recipes;
        return recipes;
    }

    private IRecipe<?>[] initializeRecipes() {
        ArrayList recipeList = new ArrayList();
        if (this.recipeDefinitions.size() != 0) {
            RecipeDefinition<?> nextRecipe;
            while ((nextRecipe = this.recipeDefinitions.poll()) != null) {
                if (nextRecipe.getPlantSet().isBroken()) {
                    LOG.warn("Skipping recipe '" + nextRecipe.getRecipeID() + "' because the PlantSet is flagged as broken!");
                    continue;
                }
                try {
                    recipeList.add(nextRecipe.getRecipe());
                }
                catch (MissingResourceException e) {
                    LOG.error("Failed to create recipe during finalization", (Throwable)e);
                    nextRecipe.getPlantSet().flagAsBroken();
                }
            }
            return recipeList.toArray(new IRecipe[0]);
        }
        return null;
    }

    static {
        LOG = ResynthMod.getNewLogger();
    }

    private static interface RecipeDefinition<T extends IRecipe<?>> {
        public T getRecipe() throws MissingResourceException;

        public PlantSet<?, ?> getPlantSet();

        public ResourceLocation getRecipeID();

        public static IItemProvider getItem(ResourceLocation itemID) {
            IItemProvider provider;
            if (ForgeRegistries.BLOCKS.containsKey(itemID) && (provider = (IItemProvider)ForgeRegistries.BLOCKS.getValue(itemID)) != null && provider != Blocks.field_150350_a) {
                return provider;
            }
            if (ForgeRegistries.ITEMS.containsKey(itemID) && (provider = (IItemProvider)ForgeRegistries.ITEMS.getValue(itemID)) != null && provider != Items.field_190931_a) {
                return provider;
            }
            return null;
        }

        public static void errorWithMissingResource(ResourceLocation recipeID, ResourceLocation resourceID) {
            throw new MissingResourceException(String.format("Cannot create recipe: '%s'! Required item: '%s' is not registered", recipeID.toString(), resourceID.toString()), recipeID.toString(), resourceID.toString());
        }
    }

    private static class FurnaceRecipeDefinition
    implements RecipeDefinition<FurnaceRecipe> {
        private final PlantSet<?, ?> plantSet;
        private final ResourceLocation id;
        private final String group;
        private final ResourceLocation inputItemID;
        private final ResourceLocation outputItemID;
        private final int count;
        private final double experience;
        private final int time;

        protected FurnaceRecipeDefinition(PlantSet<?, ?> plantSet, ResourceLocation id, String group, ResourceLocation inputItemID, ResourceLocation outputItemID, int count, double experience, int time) {
            this.plantSet = Objects.requireNonNull(plantSet);
            this.id = Objects.requireNonNull(id);
            this.group = Objects.requireNonNull(group);
            this.inputItemID = Objects.requireNonNull(inputItemID);
            this.outputItemID = Objects.requireNonNull(outputItemID);
            this.count = count < 0 ? 1 : Math.min(count, 64);
            this.experience = experience > 0.0 ? experience : 0.8;
            this.time = time > 0 ? time : 50;
        }

        @Override
        public FurnaceRecipe getRecipe() throws MissingResourceException {
            IItemProvider inputItem = RecipeDefinition.getItem(this.inputItemID);
            IItemProvider outputItem = RecipeDefinition.getItem(this.outputItemID);
            if (inputItem == null) {
                RecipeDefinition.errorWithMissingResource(this.id, this.inputItemID);
            }
            if (outputItem == null) {
                RecipeDefinition.errorWithMissingResource(this.id, this.outputItemID);
            }
            return ResynthRecipes.RecipeProvider.newFurnaceRecipe(this.id, this.group, this.experience, this.time, new ItemStack(outputItem, this.count), inputItem);
        }

        @Override
        public PlantSet<?, ?> getPlantSet() {
            return this.plantSet;
        }

        @Override
        public ResourceLocation getRecipeID() {
            return this.id;
        }
    }

    private static class ShapelessRecipeDefinition
    implements RecipeDefinition<ShapelessRecipe> {
        private final PlantSet<?, ?> plantSet;
        private final ResourceLocation id;
        private final String group;
        private final ResourceLocation[] inputItemIDs;
        private final ResourceLocation outputItemID;
        private final int count;

        protected ShapelessRecipeDefinition(PlantSet<?, ?> plantSet, ResourceLocation id, String group, ResourceLocation outputItemID, int count, ResourceLocation ... inputItemIDs) {
            this.plantSet = Objects.requireNonNull(plantSet);
            this.id = Objects.requireNonNull(id);
            this.group = Objects.requireNonNull(group);
            this.inputItemIDs = Objects.requireNonNull(inputItemIDs);
            this.outputItemID = Objects.requireNonNull(outputItemID);
            this.count = count < 0 ? 1 : Math.min(count, 64);
        }

        @Override
        public ShapelessRecipe getRecipe() throws MissingResourceException {
            IItemProvider output = RecipeDefinition.getItem(this.outputItemID);
            if (output == null) {
                RecipeDefinition.errorWithMissingResource(this.id, this.outputItemID);
            }
            ArrayList<IItemProvider> inputItems = new ArrayList<IItemProvider>();
            for (ResourceLocation inputItemID : this.inputItemIDs) {
                IItemProvider input = RecipeDefinition.getItem(inputItemID);
                if (input == null) {
                    RecipeDefinition.errorWithMissingResource(this.id, inputItemID);
                }
                inputItems.add(input);
            }
            return ResynthRecipes.RecipeProvider.newShapelessRecipe(this.id, this.group, new ItemStack(output, this.count), inputItems.toArray(new IItemProvider[0]));
        }

        @Override
        public PlantSet<?, ?> getPlantSet() {
            return this.plantSet;
        }

        @Override
        public ResourceLocation getRecipeID() {
            return this.id;
        }
    }
}

