/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.ResynthModPlants;
import com.ki11erwolf.resynth.ResynthPlants;
import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.integration.Hwyla;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

class PlantSetRegistry {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static final List<PlantSet<?, ?>> PLANT_SETS = new ArrayList(50);

    PlantSetRegistry() {
    }

    static void registerPlantSet(PlantSet<?, ?> set) {
        if (PLANT_SETS.contains(Objects.requireNonNull(set))) {
            LOG.warn("Attempt to register plant set: " + set.getSetName() + " more than once!");
            return;
        }
        LOG.debug("Queuing plant set for registration: " + set.getSetName());
        PLANT_SETS.add(set);
    }

    static PlantSet<?, ?>[] getPlantSets() {
        return PLANT_SETS.toArray(new PlantSet[0]);
    }

    static Stream<PlantSet<?, ?>> streamPlantSets() {
        return PLANT_SETS.stream();
    }

    @Mod.EventBusSubscriber(modid="resynth", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class Registerer {
        private Registerer() {
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            PLANT_SETS.forEach(set -> {
                Registerer.registerPlantBlock(set, (IForgeRegistry<Block>)event.getRegistry());
                Registerer.registerProduceItemOrBlock(set, (IForgeRegistry<Block>)event.getRegistry(), null, false);
            });
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            PLANT_SETS.forEach(set -> {
                Registerer.registerSeedsItem(set, (IForgeRegistry<Item>)event.getRegistry());
                Registerer.registerProduceItemOrBlock(set, null, (IForgeRegistry<Item>)event.getRegistry(), true);
            });
        }

        private static void registerPlantBlock(PlantSet<?, ?> set, IForgeRegistry<Block> registry) {
            LOG.debug("Registering plant block: " + set.getPlantBlock().getRegistryName());
            registry.register(set.getPlantBlock());
            Hwyla.addIfProvider(set.getPlantBlock());
        }

        public static void finalizePlantSets(FMLServerAboutToStartEvent event) {
            try {
                PLANT_SETS.forEach(PlantSet::initSeedResources);
            }
            catch (IllegalStateException e) {
                LOG.warn("Failed to finalize PlantSet initialization. Assuming PlantSets finalized earlier.", (Throwable)e);
            }
        }

        private static void registerSeedsItem(PlantSet<?, ?> set, IForgeRegistry<Item> registry) {
            LOG.debug("Registering plant seeds item: " + set.getSeedsItem().getRegistryName());
            registry.register((IForgeRegistryEntry)set.getSeedsItem());
        }

        private static void registerProduceItemOrBlock(PlantSet<?, ?> set, IForgeRegistry<Block> blockRegistry, IForgeRegistry<Item> itemRegistry, boolean forItems) {
            Item item;
            IItemProvider itemProvider = set.getProduceItem();
            boolean isItem = itemProvider instanceof Item;
            boolean isBlock = itemProvider instanceof Block;
            Block block = isBlock ? (Block)itemProvider : null;
            Item item2 = item = !isBlock && isItem ? (Item)itemProvider : null;
            ResourceLocation registryName = block != null ? block.getRegistryName() : (item != null ? item.getRegistryName() : new ResourceLocation("resynth", "registry-error"));
            if (isBlock && !forItems) {
                LOG.debug("Registering plant produce block: " + registryName);
                blockRegistry.register((IForgeRegistryEntry)block);
                Hwyla.addIfProvider(block);
            }
            if (isBlock && forItems) {
                LOG.debug("Registering plant produce ItemBlock: " + registryName);
                if (!(block instanceof ResynthBlock)) {
                    LOG.warn("Cannot register an ItemBlock as it doesn't inherit from ResynthBlock: " + registryName);
                } else {
                    itemRegistry.register((IForgeRegistryEntry)((ResynthBlock)block).getItemBlock());
                }
            }
            if (isItem && forItems) {
                LOG.debug("Registering plant produce item: " + registryName);
                itemRegistry.register((IForgeRegistryEntry)((Item)itemProvider));
            }
        }

        static {
            LOG.info("Queuing plant set registration...");
            ResynthPlants.initSets();
            ResynthModPlants.initSets();
            MinecraftForge.EVENT_BUS.addListener(Registerer::finalizePlantSets);
        }
    }
}

