/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.packet.ClientAVEffectPacket;
import com.ki11erwolf.resynth.packet.Packet;
import com.ki11erwolf.resynth.util.MinecraftUtil;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.network.PacketDistributor;

class PlantSetSeedHooks {
    private static final double PLAYER_EFFECT_RADIUS = 7.0;
    private boolean registered = false;

    PlantSetSeedHooks() {
    }

    void register() {
        if (this.registered) {
            return;
        }
        this.registered = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    static void dropSeeds(Item seeds, World world, BlockPos pos) {
        PlantSetSeedHooks.spawnSeedsStack(seeds, world, pos);
        PlantSetSeedHooks.playEffects(pos, world);
    }

    private static void spawnSeedsStack(Item seeds, World world, BlockPos pos) {
        MinecraftUtil.spawnItemInWorld(seeds, world, pos);
    }

    private static void playEffects(BlockPos pos, World world) {
        Packet.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 7.0, world.func_234923_W_())), new ClientAVEffectPacket(ClientAVEffectPacket.AVEffect.SEEDS_SPAWNED, pos));
    }
}

