/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.plant.set.BiochemicalSet;
import com.ki11erwolf.resynth.plant.set.CrystallineSet;
import com.ki11erwolf.resynth.plant.set.MetallicSet;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.properties.AbstractBiochemicalProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractCrystallineProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractMetallicProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractPlantSetProperties;
import com.ki11erwolf.resynth.util.CommonRKeys;
import com.ki11erwolf.resynth.util.ExpandingTooltip;
import com.ki11erwolf.resynth.util.Tooltip;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.text.WordUtils;

public class PlantSetTooltips {
    private PlantSetTooltips() {
    }

    public static void addWarningIfBroken(List<ITextComponent> tooltip, PlantSet<?, ?> plantSet) {
        if (!plantSet.isBroken()) {
            return;
        }
        new ExpandingTooltip().setCondition(CommonRKeys.SHIFT.rKey.query() || CommonRKeys.CONTROL.rKey.query()).setExpandedTooltip(Tooltip::addBlankLine).setCollapsedTooltip(collapsedTooltip -> {}).write(tooltip);
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RED.toString() + TextFormatting.UNDERLINE + PlantSetTooltips.getFormattedTooltip("broken", TextFormatting.UNDERLINE, new Object[0]).func_150261_e()));
        new ExpandingTooltip().setConditionToControlDown().setExpandedTooltip(expandedTooltip -> {
            expandedTooltip.addAll(Arrays.asList(Tooltip.formatLineFeeds((ITextComponent)new StringTextComponent(WordUtils.wrap((String)PlantSetTooltips.getFormattedTooltip("broken.information", TextFormatting.DARK_RED, new Object[0]).func_150261_e(), (int)ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).getTooltipCharacterLimit(), (String)"\n", (boolean)true)), TextFormatting.DARK_RED)));
            Tooltip.addBlankLine(expandedTooltip);
        }).setCollapsedTooltip(x -> {}).write(Tooltip.addBlankLine(tooltip));
    }

    public static void setPropertiesTooltip(List<ITextComponent> tooltip, PlantSet<?, ?> set) {
        AbstractPlantSetProperties properties = set.serverPlantSetProperties().orElse(null);
        if (properties != null) {
            tooltip.add(PlantSetTooltips.getFormattedTooltip("synchronized", TextFormatting.DARK_GREEN, TextFormatting.BOLD.toString() + TextFormatting.ITALIC.toString()));
            tooltip.add((ITextComponent)new StringTextComponent(""));
        } else {
            properties = set.getPlantSetProperties();
        }
        boolean bonemeal = properties.bonemealGrowth();
        tooltip.add(PlantSetTooltips.getFormattedTooltip(bonemeal ? "bonemeal_effective" : "bonemeal_ineffective", TextFormatting.RED, bonemeal ? TextFormatting.DARK_GREEN : TextFormatting.DARK_RED));
        tooltip.add(PlantSetTooltips.getFormattedTooltip("growth_rate", TextFormatting.BLUE, TextFormatting.GOLD, properties.growthProbability() + "%"));
        PlantSetTooltips.setSourcesForSeeds(tooltip, set);
        if (properties instanceof AbstractCrystallineProperties) {
            PlantSetTooltips.setCrystallinePropertiesTooltip(tooltip, (AbstractCrystallineProperties)properties);
        } else if (properties instanceof AbstractMetallicProperties) {
            PlantSetTooltips.setMetallicPropertiesTooltip(tooltip, (AbstractMetallicProperties)properties);
        } else if (properties instanceof AbstractBiochemicalProperties) {
            PlantSetTooltips.setBiochemicalPropertiesTooltip(tooltip, (AbstractBiochemicalProperties)properties);
        }
        int produceYield = set.serverPlantSetProduceProperties().orElse(set.getProduceProperties()).produceYield();
        tooltip.add(PlantSetTooltips.getFormattedTooltip(produceYield == 1 ? "produce_yield_singular" : "produce_yield", TextFormatting.DARK_PURPLE, TextFormatting.GOLD, produceYield, TextFormatting.DARK_PURPLE));
    }

    private static void setSourcesForSeeds(List<ITextComponent> tooltip, PlantSet<?, ?> set) {
        String s;
        if (set.isBroken() || set.getSeedSources() == null) {
            return;
        }
        int limit = 5;
        int seedSourcesCount = set.getSeedSources().length;
        String string = s = seedSourcesCount > limit ? " +" + (seedSourcesCount - limit) : "";
        if (set instanceof CrystallineSet) {
            tooltip.add(PlantSetTooltips.getFormattedTooltip("seed_sources", TextFormatting.GREEN, PlantSetTooltips.getFormattedTooltip("seed_sources.crystalline", TextFormatting.DARK_GREEN, new Object[0]).getString(), TextFormatting.WHITE, Tooltip.toTextComponent(Arrays.toString(Arrays.stream(set.getSeedSources(Block[].class)).limit(limit).map(in -> TextFormatting.GOLD + in.func_235333_g_().getString() + TextFormatting.WHITE).toArray()) + s).getString()));
        } else if (set instanceof MetallicSet) {
            tooltip.add(PlantSetTooltips.getFormattedTooltip("seed_sources", TextFormatting.GREEN, PlantSetTooltips.getFormattedTooltip("seed_sources.metallic", TextFormatting.DARK_GREEN, new Object[0]).getString(), TextFormatting.WHITE, Tooltip.toTextComponent(Arrays.toString(Arrays.stream(set.getSeedSources(Block[].class)).limit(limit).map(in -> TextFormatting.GOLD + in.func_235333_g_().getString() + TextFormatting.WHITE).toArray()) + s).getString()));
        } else if (set instanceof BiochemicalSet) {
            tooltip.add(PlantSetTooltips.getFormattedTooltip("seed_sources", TextFormatting.GREEN, PlantSetTooltips.getFormattedTooltip("seed_sources.biochemical", TextFormatting.DARK_GREEN, new Object[0]).getString(), TextFormatting.WHITE, Tooltip.toTextComponent(Arrays.toString(Arrays.stream(set.getSeedSources(EntityType[].class)).limit(limit).map(in -> TextFormatting.GOLD + in.func_212546_e().getString() + TextFormatting.WHITE).toArray()) + s).getString()));
        }
    }

    private static void setCrystallinePropertiesTooltip(List<ITextComponent> tooltip, AbstractCrystallineProperties properties) {
        tooltip.add(PlantSetTooltips.getFormattedTooltip(properties.plantYield() == 1 ? "plant_yield_singular" : "plant_yield", TextFormatting.DARK_AQUA, TextFormatting.GOLD, properties.plantYield(), TextFormatting.DARK_AQUA));
        tooltip.add(PlantSetTooltips.getFormattedTooltip("ore_seed_drop_rate", TextFormatting.AQUA, TextFormatting.GOLD, properties.seedSpawnChanceFromOre() + "%", TextFormatting.AQUA));
        tooltip.add(PlantSetTooltips.getFormattedTooltip("produce_seed_drop_rate", TextFormatting.LIGHT_PURPLE, TextFormatting.GOLD, properties.seedSpawnChanceFromShard() + "%", TextFormatting.LIGHT_PURPLE));
    }

    private static void setMetallicPropertiesTooltip(List<ITextComponent> tooltip, AbstractMetallicProperties properties) {
        tooltip.add(PlantSetTooltips.getFormattedTooltip("ore_seed_drop_rate", TextFormatting.AQUA, TextFormatting.GOLD, properties.seedSpawnChanceFromOre() + "%", TextFormatting.AQUA));
        tooltip.add(PlantSetTooltips.getFormattedTooltip("produce_seed_drop_rate", TextFormatting.LIGHT_PURPLE, TextFormatting.GOLD, properties.seedSpawnChanceFromOrganicOre() + "%", TextFormatting.LIGHT_PURPLE));
    }

    private static void setBiochemicalPropertiesTooltip(List<ITextComponent> tooltip, AbstractBiochemicalProperties properties) {
        tooltip.add(PlantSetTooltips.getFormattedTooltip(properties.plantYield() == 1 ? "plant_yield_singular" : "plant_yield", TextFormatting.DARK_AQUA, TextFormatting.GOLD, properties.plantYield(), TextFormatting.DARK_AQUA));
        tooltip.add(PlantSetTooltips.getFormattedTooltip("mob_seed_drop_rate", TextFormatting.AQUA, TextFormatting.GOLD, properties.seedSpawnChanceFromMob() + "%", TextFormatting.AQUA));
        tooltip.add(PlantSetTooltips.getFormattedTooltip("produce_seed_drop_rate", TextFormatting.LIGHT_PURPLE, TextFormatting.GOLD, properties.seedSpawnChanceFromBulb() + "%", TextFormatting.LIGHT_PURPLE));
    }

    private static ITextComponent getFormattedTooltip(String key, TextFormatting color, Object ... params) {
        return new StringTextComponent(color + I18n.func_135052_a((String)("tooltip.resynth.plantset.property." + key), (Object[])params));
    }
}

