/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.packet.Packet;
import com.ki11erwolf.resynth.packet.SyncSetPropertiesPacket;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetAPI;
import com.ki11erwolf.resynth.plant.set.PlantSetRegistry;
import com.ki11erwolf.resynth.plant.set.properties.AbstractPlantSetProperties;
import com.ki11erwolf.resynth.plant.set.properties.AbstractProduceProperties;
import com.ki11erwolf.resynth.util.SideUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

enum PropertiesSynchronizer {
    INSTANCE;

    private static final Logger LOG;

    protected void handleClientConnection(PlayerEntity playerEntity, MinecraftServer server) {
        if (!(playerEntity instanceof ServerPlayerEntity)) {
            LOG.error("[Server] Cannot synchronize with connected client! Invalid PlayerEntity type!");
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)playerEntity;
        if (server instanceof DedicatedServer) {
            this.synchronizeWithClient(player);
        } else if (!player.func_71114_r().equals("local")) {
            this.synchronizeWithClient(player);
        } else {
            this.restoreClient();
        }
    }

    protected void handlePropertiesSynchronizing(String setName, AbstractPlantSetProperties properties, AbstractProduceProperties produceProperties) {
        if (SideUtil.isClientSafe()) {
            this.synchronizeSetProperties(PlantSetAPI.getSetByName(setName), properties, produceProperties);
        } else {
            LOG.error("[Server] Cannot perform synchronization on Dedicated Server!");
        }
    }

    private void synchronizeWithClient(ServerPlayerEntity connectedClient) {
        LOG.info("[Server] A Client(ip=" + connectedClient.func_71114_r() + ") has connected! Attempting to synchronize the client  with the servers PlantSet Properties...");
        PlantSetRegistry.streamPlantSets().forEach(serverPlantSet -> {
            LOG.debug("[Server] Sending synchronization request for the '" + serverPlantSet.getSetName() + "' PlantSet Properties");
            Packet.send(PacketDistributor.PLAYER.with(() -> connectedClient), new SyncSetPropertiesPacket(serverPlantSet.getSetName(), serverPlantSet.getPlantSetProperties(), serverPlantSet.getProduceProperties()));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void synchronizeSetProperties(PlantSet<?, ?> plantSet, AbstractPlantSetProperties properties, AbstractProduceProperties produce) {
        if (plantSet != null) {
            LOG.info("[Client] Synchronizing own '" + plantSet.getSetName() + "' PlantSet with the Properties sent by the servers.");
            plantSet.setServerPlantSetProperties(properties);
            plantSet.setServerPlantSetProduceProperties(produce);
        } else {
            LOG.error("[Client] Failed to synchronize! The requested PlantSet is unknown, invalid, or not registered!");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void restoreClient() {
        LOG.info("[Client] Connected to local world! Ensuring PlantSets use Client Properties...");
        long count = PlantSetRegistry.streamPlantSets().peek(clientPlantSet -> {
            clientPlantSet.clearServerPlantSetProperties();
            clientPlantSet.clearServerPlantSetProduceProperties();
        }).count();
        LOG.info("[Client] Processed " + count + " PlantSet Properties!");
    }

    static {
        LOG = ResynthMod.getNewLogger();
    }

    @Mod.EventBusSubscriber(modid="resynth", bus=Mod.EventBusSubscriber.Bus.FORGE)
    private static class Hooks {
        private Hooks() {
        }

        @SubscribeEvent
        public static void onPlayerServerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerEntity player = event.getPlayer();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            INSTANCE.handleClientConnection(event.getPlayer(), server);
        }
    }
}

