/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set.properties;

import com.ki11erwolf.resynth.plant.set.properties.AbstractBiochemicalProperties;
import com.ki11erwolf.resynth.plant.set.properties.SerializedPropertyValue;
import com.ki11erwolf.resynth.util.JSerializer;

public class BiochemicalProperties
implements AbstractBiochemicalProperties {
    private final boolean canBonemeal;
    private final float chanceToGrow;
    private final int numberOfProduceDrops;
    private final float seedSpawnChanceFromMob;
    private final float seedSpawnChanceFromBulb;

    public BiochemicalProperties(boolean canBonemeal, float chanceToGrow, int numberOfProduceDrops, float seedSpawnChanceFromMob, float seedSpawnChanceFromBulb) {
        this.canBonemeal = canBonemeal;
        this.chanceToGrow = chanceToGrow;
        this.numberOfProduceDrops = numberOfProduceDrops;
        this.seedSpawnChanceFromMob = seedSpawnChanceFromMob;
        this.seedSpawnChanceFromBulb = seedSpawnChanceFromBulb;
    }

    @Override
    public boolean bonemealGrowth() {
        return this.canBonemeal;
    }

    @Override
    public float growthProbability() {
        return this.chanceToGrow;
    }

    @Override
    public int plantYield() {
        return this.numberOfProduceDrops;
    }

    @Override
    public float seedSpawnChanceFromMob() {
        return this.seedSpawnChanceFromMob;
    }

    @Override
    public float seedSpawnChanceFromBulb() {
        return this.seedSpawnChanceFromBulb;
    }

    static class BiochemicalPropertiesSerializer
    extends JSerializer<AbstractBiochemicalProperties> {
        BiochemicalPropertiesSerializer() {
            super("biochemical-plant-set-properties");
        }

        @Override
        protected void objectToData(AbstractBiochemicalProperties object, JSerializer.JSerialDataIO dataIO) {
            dataIO.add(SerializedPropertyValue.TYPE_OF_PROPERTIES.key, "biochemical");
            dataIO.add(SerializedPropertyValue.PROBABILITY_OF_GROWING.key, Float.valueOf(object.growthProbability()));
            dataIO.add(SerializedPropertyValue.FERTILIZED_BY_BONEMEAL.key, object.bonemealGrowth());
            dataIO.add(SerializedPropertyValue.PLANT_HARVEST_YIELD.key, object.plantYield());
            dataIO.add(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_SOURCE.key, Float.valueOf(object.seedSpawnChanceFromMob()));
            dataIO.add(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_PRODUCE.key, Float.valueOf(object.seedSpawnChanceFromBulb()));
        }

        @Override
        protected AbstractBiochemicalProperties dataToObject(AbstractBiochemicalProperties suggestedObject, JSerializer.JSerialDataIO dataIO) throws Exception {
            if (!"biochemical".equals(dataIO.getString(SerializedPropertyValue.TYPE_OF_PROPERTIES.key))) {
                throw new Exception("Not of type Biochemical!");
            }
            boolean bonemealGrowth = dataIO.getBoolean(SerializedPropertyValue.FERTILIZED_BY_BONEMEAL.key);
            int plantYield = dataIO.get(SerializedPropertyValue.PLANT_HARVEST_YIELD.key).getAsInt();
            float growthProbability = dataIO.get(SerializedPropertyValue.PROBABILITY_OF_GROWING.key).getAsFloat();
            float seedSpawnChanceFromMob = dataIO.get(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_SOURCE.key).getAsFloat();
            float seedSpawnChanceFromBulb = dataIO.get(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_PRODUCE.key).getAsFloat();
            return new BiochemicalProperties(bonemealGrowth, growthProbability, plantYield, seedSpawnChanceFromMob, seedSpawnChanceFromBulb);
        }

        @Override
        protected AbstractBiochemicalProperties createInstance() {
            return new BiochemicalProperties(false, 0.0f, 0, 0.0f, 0.0f);
        }
    }
}

