/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set.properties;

import com.ki11erwolf.resynth.plant.set.properties.AbstractCrystallineProperties;
import com.ki11erwolf.resynth.plant.set.properties.SerializedPropertyValue;
import com.ki11erwolf.resynth.util.JSerializer;

public class CrystallineProperties
implements AbstractCrystallineProperties {
    private final boolean canBonemeal;
    private final float chanceToGrow;
    private final int numberOfProduceDrops;
    private final float seedSpawnChanceFromOre;
    private final float seedSpawnChanceFromShard;
    private final int resourcesPerSeeds;

    public CrystallineProperties(boolean canBonemeal, float chanceToGrow, int numberOfProduceDrops, float seedSpawnChanceFromOre, float seedSpawnChanceFromShard) {
        this(canBonemeal, chanceToGrow, numberOfProduceDrops, seedSpawnChanceFromOre, seedSpawnChanceFromShard, 2);
    }

    public CrystallineProperties(boolean canBonemeal, float chanceToGrow, int numberOfProduceDrops, float seedSpawnChanceFromOre, float seedSpawnChanceFromShard, int resourcesPerSeeds) {
        this.canBonemeal = canBonemeal;
        this.chanceToGrow = chanceToGrow;
        this.numberOfProduceDrops = numberOfProduceDrops;
        this.seedSpawnChanceFromOre = seedSpawnChanceFromOre;
        this.seedSpawnChanceFromShard = seedSpawnChanceFromShard;
        this.resourcesPerSeeds = Math.min(resourcesPerSeeds, 64);
    }

    @Override
    public boolean bonemealGrowth() {
        return this.canBonemeal;
    }

    @Override
    public float growthProbability() {
        return this.chanceToGrow;
    }

    @Override
    public int plantYield() {
        return this.numberOfProduceDrops;
    }

    @Override
    public float seedSpawnChanceFromOre() {
        return this.seedSpawnChanceFromOre;
    }

    @Override
    public float seedSpawnChanceFromShard() {
        return this.seedSpawnChanceFromShard;
    }

    @Override
    public int seedCraftingYield() {
        return this.resourcesPerSeeds;
    }

    static class CrystallinePropertiesSerializer
    extends JSerializer<AbstractCrystallineProperties> {
        CrystallinePropertiesSerializer() {
            super("crystalline-plant-set-properties");
        }

        @Override
        protected void objectToData(AbstractCrystallineProperties object, JSerializer.JSerialDataIO dataIO) {
            dataIO.add(SerializedPropertyValue.TYPE_OF_PROPERTIES.key, "crystalline");
            dataIO.add(SerializedPropertyValue.CRYSTALLINE_PRODUCE_SEED_YIELD.key, object.seedCraftingYield());
            dataIO.add(SerializedPropertyValue.PROBABILITY_OF_GROWING.key, Float.valueOf(object.growthProbability()));
            dataIO.add(SerializedPropertyValue.FERTILIZED_BY_BONEMEAL.key, object.bonemealGrowth());
            dataIO.add(SerializedPropertyValue.PLANT_HARVEST_YIELD.key, object.plantYield());
            dataIO.add(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_SOURCE.key, Float.valueOf(object.seedSpawnChanceFromOre()));
            dataIO.add(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_PRODUCE.key, Float.valueOf(object.seedSpawnChanceFromShard()));
        }

        @Override
        protected AbstractCrystallineProperties dataToObject(AbstractCrystallineProperties suggestedObject, JSerializer.JSerialDataIO dataIO) throws Exception {
            if (!"crystalline".equals(dataIO.getString(SerializedPropertyValue.TYPE_OF_PROPERTIES.key))) {
                throw new Exception("Not of type Crystalline!");
            }
            boolean bonemealGrowth = dataIO.getBoolean(SerializedPropertyValue.FERTILIZED_BY_BONEMEAL.key);
            float growthProbability = dataIO.get(SerializedPropertyValue.PROBABILITY_OF_GROWING.key).getAsFloat();
            float seedSpawnChanceFromMob = dataIO.get(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_SOURCE.key).getAsFloat();
            float seedSpawnChanceFromBulb = dataIO.get(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_PRODUCE.key).getAsFloat();
            int plantYield = dataIO.get(SerializedPropertyValue.PLANT_HARVEST_YIELD.key).getAsInt();
            int craftingYield = dataIO.getInteger(SerializedPropertyValue.CRYSTALLINE_PRODUCE_SEED_YIELD.key);
            return new CrystallineProperties(bonemealGrowth, growthProbability, plantYield, seedSpawnChanceFromMob, seedSpawnChanceFromBulb, craftingYield);
        }

        @Override
        protected AbstractCrystallineProperties createInstance() {
            return new CrystallineProperties(false, 0.0f, 0, 0.0f, 0.0f);
        }
    }
}

