/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set.properties;

import com.ki11erwolf.resynth.plant.set.properties.AbstractMetallicProperties;
import com.ki11erwolf.resynth.plant.set.properties.SerializedPropertyValue;
import com.ki11erwolf.resynth.util.JSerializer;

public class MetallicProperties
implements AbstractMetallicProperties {
    private final boolean canBonemeal;
    private final float chanceToGrow;
    private final float seedSpawnChanceFromOre;
    private final float seedSpawnChanceFromOrganicOre;

    public MetallicProperties(boolean canBonemeal, float chanceToGrow, float seedSpawnChanceFromOre, float seedSpawnChanceFromOrganicOre) {
        this.canBonemeal = canBonemeal;
        this.chanceToGrow = chanceToGrow;
        this.seedSpawnChanceFromOre = seedSpawnChanceFromOre;
        this.seedSpawnChanceFromOrganicOre = seedSpawnChanceFromOrganicOre;
    }

    @Override
    public boolean bonemealGrowth() {
        return this.canBonemeal;
    }

    @Override
    public float growthProbability() {
        return this.chanceToGrow;
    }

    @Override
    public float seedSpawnChanceFromOre() {
        return this.seedSpawnChanceFromOre;
    }

    @Override
    public float seedSpawnChanceFromOrganicOre() {
        return this.seedSpawnChanceFromOrganicOre;
    }

    static class MetallicPropertiesSerializer
    extends JSerializer<AbstractMetallicProperties> {
        MetallicPropertiesSerializer() {
            super("metallic-plant-set-properties");
        }

        @Override
        protected void objectToData(AbstractMetallicProperties object, JSerializer.JSerialDataIO dataIO) {
            dataIO.add(SerializedPropertyValue.TYPE_OF_PROPERTIES.key, "metallic");
            dataIO.add(SerializedPropertyValue.PROBABILITY_OF_GROWING.key, Float.valueOf(object.growthProbability()));
            dataIO.add(SerializedPropertyValue.FERTILIZED_BY_BONEMEAL.key, object.bonemealGrowth());
            dataIO.add(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_SOURCE.key, Float.valueOf(object.seedSpawnChanceFromOre()));
            dataIO.add(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_PRODUCE.key, Float.valueOf(object.seedSpawnChanceFromOrganicOre()));
        }

        @Override
        protected AbstractMetallicProperties dataToObject(AbstractMetallicProperties suggestedObject, JSerializer.JSerialDataIO dataIO) throws Exception {
            if (!"metallic".equals(dataIO.getString(SerializedPropertyValue.TYPE_OF_PROPERTIES.key))) {
                throw new Exception("Not of type Metallic!");
            }
            boolean bonemealGrowth = dataIO.getBoolean(SerializedPropertyValue.FERTILIZED_BY_BONEMEAL.key);
            float growthProbability = dataIO.get(SerializedPropertyValue.PROBABILITY_OF_GROWING.key).getAsFloat();
            float seedSpawnChanceFromMob = dataIO.get(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_SOURCE.key).getAsFloat();
            float seedSpawnChanceFromBulb = dataIO.get(SerializedPropertyValue.SEED_SPAWN_PROBABILITY_FROM_PRODUCE.key).getAsFloat();
            return new MetallicProperties(bonemealGrowth, growthProbability, seedSpawnChanceFromMob, seedSpawnChanceFromBulb);
        }

        @Override
        protected AbstractMetallicProperties createInstance() {
            return new MetallicProperties(false, 0.0f, 0.0f, 0.0f);
        }
    }
}

