/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set.properties;

import com.ki11erwolf.resynth.plant.set.properties.AbstractProduceProperties;
import com.ki11erwolf.resynth.plant.set.properties.SerializedPropertyValue;
import com.ki11erwolf.resynth.util.JSerializer;

public class ProduceProperties
implements AbstractProduceProperties {
    private final int resourceCount;
    private final int smeltingTime;
    private final double experienceWorth;

    public ProduceProperties(int resourceCount, int smeltingTime, double experienceWorth) {
        this.resourceCount = resourceCount < 0 ? 1 : Math.min(resourceCount, 64);
        this.smeltingTime = smeltingTime < 0 ? 200 : smeltingTime;
        this.experienceWorth = experienceWorth < 0.0 ? 1.0 : experienceWorth;
    }

    @Override
    public final int produceYield() {
        return this.resourceCount;
    }

    @Override
    public final int timePerYield() {
        return this.smeltingTime;
    }

    @Override
    public final double experiencePoints() {
        return this.experienceWorth;
    }

    static class ProducePropertiesSerializer
    extends JSerializer<AbstractProduceProperties> {
        ProducePropertiesSerializer() {
            super("plant-set-produce-properties");
        }

        @Override
        protected void objectToData(AbstractProduceProperties object, JSerializer.JSerialDataIO dataIO) {
            dataIO.add(SerializedPropertyValue.TYPE_OF_PROPERTIES.key, "produce");
            dataIO.add(SerializedPropertyValue.SMELTED_PRODUCE_YIELD.key, object.produceYield());
        }

        @Override
        protected AbstractProduceProperties dataToObject(AbstractProduceProperties suggested, JSerializer.JSerialDataIO dataIO) throws Exception {
            if (!"produce".equals(dataIO.getString(SerializedPropertyValue.TYPE_OF_PROPERTIES.key))) {
                throw new Exception("Not of type Produce!");
            }
            int yield = dataIO.get(SerializedPropertyValue.SMELTED_PRODUCE_YIELD.key).getAsInt();
            return new ProduceProperties(yield, 200, 2.0);
        }

        @Override
        protected AbstractProduceProperties createInstance() {
            return new ProduceProperties(0, 0, 0.0);
        }
    }
}

