/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.util.RKey;
import org.apache.logging.log4j.Logger;

public enum CommonRKeys {
    RIGHT_CONTROL(new RKey("key.keyboard.right.control", 345)),
    LEFT_CONTROL(new RKey("key.keyboard.left.control", 341)),
    CONTROL(RKey.Mode.ANY, RIGHT_CONTROL, LEFT_CONTROL),
    RIGHT_ALT(new RKey("key.keyboard.right.alt", 346)),
    LEFT_ALT(new RKey("key.keyboard.left.alt", 342)),
    ALT(RKey.Mode.ANY, RIGHT_ALT, LEFT_ALT),
    RIGHT_SHIFT(new RKey("key.keyboard.right.shift", 344)),
    LEFT_SHIFT(new RKey("key.keyboard.left.shift", 340)),
    SHIFT(RKey.Mode.ANY, RIGHT_SHIFT, LEFT_SHIFT);

    public final RKey rKey;

    private CommonRKeys(RKey key) {
        this.rKey = key;
        if (this.rKey == null) {
            throw new IllegalStateException("CommonKeys enums cannot return a null RKey, yet one did.");
        }
    }

    private CommonRKeys(RKey.Mode mode, CommonRKeys left, CommonRKeys right) {
        this(new RKey(mode, left.rKey.getKeyCodes()[0], right.rKey.getKeyCodes()[0]));
    }

    static {
        Logger log = ResynthMod.getNewLogger();
        log.info("Validating all CommonRKeys that qualify...");
        for (CommonRKeys commonRKey : CommonRKeys.values()) {
            if (!commonRKey.rKey.hasValidatableName() || !commonRKey.rKey.isSingle() || commonRKey.rKey.validate()) continue;
            log.error("CommonRKeys '" + commonRKey.rKey.getName() + "' failed validation!");
        }
    }
}

