/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import com.ki11erwolf.resynth.util.CommonRKeys;
import com.ki11erwolf.resynth.util.CommonTooltips;
import com.ki11erwolf.resynth.util.Tooltip;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public class ExpandingTooltip {
    private boolean conditionMet = false;
    private Tooltip collapsed = CommonTooltips.UNSPECIFIED;
    private Tooltip expanded = CommonTooltips.UNSPECIFIED;

    public List<ITextComponent> write(List<ITextComponent> tooltip) {
        if (this.conditionMet) {
            this.expanded.write(tooltip);
        } else {
            this.collapsed.write(tooltip);
        }
        return tooltip;
    }

    public ExpandingTooltip setCondition(boolean condition) {
        this.conditionMet = condition;
        return this;
    }

    public ExpandingTooltip setConditionToShiftDown() {
        this.conditionMet = CommonRKeys.SHIFT.rKey.query();
        return this;
    }

    public ExpandingTooltip setConditionToControlDown() {
        this.conditionMet = CommonRKeys.CONTROL.rKey.query();
        return this;
    }

    public ExpandingTooltip setConditionToAltDown() {
        this.conditionMet = CommonRKeys.ALT.rKey.query();
        return this;
    }

    public ExpandingTooltip setCollapsedTooltip(Tooltip tooltip) {
        this.collapsed = tooltip == null ? CommonTooltips.NULL : tooltip;
        return this;
    }

    public ExpandingTooltip setExpandedTooltip(Tooltip tooltip) {
        this.expanded = tooltip == null ? CommonTooltips.NULL : tooltip;
        return this;
    }

    public ExpandingTooltip setShiftForStats(Tooltip expanded) {
        this.setConditionToShiftDown().setCollapsedTooltip(CommonTooltips.SHIFT_FOR_STATS).setExpandedTooltip(expanded);
        return this;
    }

    public ExpandingTooltip setCtrlForDescription(Tooltip expanded) {
        boolean isFiring = CommonRKeys.CONTROL.rKey.query();
        this.setCondition(isFiring && Tooltip.areTooltipsEnabled()).setCollapsedTooltip(Tooltip.areTooltipsEnabled() ? CommonTooltips.CTRL_FOR_DESCRIPTION : CommonTooltips.NULL).setExpandedTooltip(expanded);
        return this;
    }

    public ExpandingTooltip setAltForAdditionalInfo(Tooltip expanded) {
        this.setConditionToAltDown().setCollapsedTooltip(CommonTooltips.ALT_FOR_ADDITIONAL_INFO).setExpandedTooltip(expanded);
        return this;
    }
}

