/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.ki11erwolf.resynth.ResynthMod;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.Logger;

public abstract class JSerializer<T extends JSerializable<T>> {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private final String identification;
    private final int version;

    public JSerializer(String identification) {
        this(identification, 1);
    }

    public JSerializer(String identification, int version) {
        if (Objects.requireNonNull(identification).isEmpty()) {
            throw new IllegalArgumentException("An empty String is not valid as JSerializer identification.");
        }
        this.identification = identification;
        this.version = version > 0 ? version : 1;
    }

    public String getIdentification() {
        return this.identification;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return String.format("JSerializer[identification=%s, version=%s]", this.identification, this.version);
    }

    public JSerialData serializeObject(T object) throws SerializeException {
        return this.iserialize(object);
    }

    public T deserializeData(JSerialData data, T suggestedInstance) throws DataMismatchException, SerializeException {
        return this.ideserialize(data, suggestedInstance);
    }

    public T deserializeData(JSerialData data) throws DataMismatchException, SerializeException {
        T newObject;
        try {
            newObject = this.createInstance();
            if (newObject == null) {
                throw new NullPointerException(this.toString() + " method 'createInstance()' gave a null JSerializable object .");
            }
        }
        catch (Exception cause) {
            throw new SerializeException("Failed to create new JSerializable during deserialization.", cause);
        }
        return this.ideserialize(data, newObject);
    }

    protected abstract void objectToData(T var1, JSerialDataIO var2) throws Exception;

    protected abstract T dataToObject(T var1, JSerialDataIO var2) throws Exception;

    protected abstract T createInstance();

    protected void fixVersionMissMatch(JSerialDataIO dataIO, int version, int dataVersion) throws Exception {
        throw new UnsupportedOperationException("This JSerializer only supports a single version: Version " + version + ".");
    }

    private JSerialData iserialize(T object) throws SerializeException {
        JSerialDataIO dataIO = this.getNewJSerialDataIO();
        try {
            this.objectToData(object, dataIO);
        }
        catch (Exception cause) {
            SerializeException toThrow = new SerializeException("JSerializer '" + this.getIdentification() + "' failed to covert JSerializable object to data", cause);
            LOG.error(toThrow.getMessage(), (Throwable)cause);
            throw toThrow;
        }
        return dataIO.getJSerialData();
    }

    private T ideserialize(JSerialData data, T newObject) throws DataMismatchException {
        T providedObject;
        this.matchData(data);
        try {
            providedObject = this.dataToObject(newObject, data.io);
        }
        catch (Exception cause) {
            SerializeException toThrow = new SerializeException("JSerializer " + this.getIdentification() + "' failed to convert data to JSerializable object", cause);
            LOG.error(toThrow.getMessage(), (Throwable)cause);
            throw toThrow;
        }
        return providedObject == null ? newObject : providedObject;
    }

    private JSerialDataIO getNewJSerialDataIO() {
        JSerialData data = new JSerialData(this);
        return data.io;
    }

    private boolean doesDataIdentificationMatch(JSerialData data) {
        return data.io.getIdentification().equals(this.identification);
    }

    private boolean doesDataVersionMatch(JSerialData data) {
        return data.io.getVersion() == this.version;
    }

    private void matchData(JSerialData data) throws DataMismatchException {
        boolean missMatch = false;
        if (!this.doesDataIdentificationMatch(data)) {
            missMatch = true;
        }
        if (!this.doesDataVersionMatch(data)) {
            try {
                this.fixVersionMissMatch(data.io, this.getVersion(), data.io.getVersion());
            }
            catch (Exception cause) {
                missMatch = true;
            }
        }
        if (missMatch) {
            throw new DataMismatchException("Cannot deserialize " + data.toString() + " with " + this.toString());
        }
    }

    public static <T extends JSerializable<T>> JSerialData serialize(T object) {
        JSerializer<T> serializer = object.getSerializer();
        return serializer.serializeObject(object);
    }

    public static <T extends JSerializable<T>> T deserialize(JSerialData serializedData, JSerializer<T> serializer) throws DataMismatchException {
        return serializer.deserializeData(serializedData);
    }

    public static <T extends JSerializable<T>> T deserialize(JSerialData serializedData, Class<? extends T> object) throws DataMismatchException {
        T newInstance = JSerializer.constructSerializableObject(object);
        JSerializer<T> serializer = newInstance.getSerializer();
        return serializer.deserializeData(serializedData, newInstance);
    }

    private static <T extends JSerializable<T>> T constructSerializableObject(Class<? extends T> object) {
        Constructor objectConstructor = Arrays.stream(object.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 0).peek(constructor -> {
            if (constructor.isAccessible()) {
                LOG.warn("Serializable object '" + object.getCanonicalName() + "' has accessible default constructor.");
            } else {
                constructor.setAccessible(true);
            }
        }).findFirst().orElseThrow(() -> new IllegalArgumentException("Serializable object '" + object.getCanonicalName() + "' has no default constructor available."));
        try {
            Object objectInstance = objectConstructor.newInstance(new Object[0]);
            if (!(objectInstance instanceof JSerializable)) {
                throw new IllegalArgumentException("Serializable object '" + object.getCanonicalName() + "' not of type JSerializable");
            }
            try {
                return (T)((JSerializable)objectInstance);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Serializable object '" + object.getCanonicalName() + "' cast failed", e);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Serializable object '" + object.getCanonicalName() + "' could not be instantiated", e);
        }
    }

    public static class SerializeException
    extends RuntimeException {
        private SerializeException(String message) {
            super(message);
        }

        private SerializeException(String message, Exception cause) {
            super(message, cause);
        }
    }

    public static final class DataMismatchException
    extends SerializeException {
        private DataMismatchException(String message) {
            super(message);
        }

        private DataMismatchException(String message, Exception cause) {
            super(message, cause);
        }
    }

    protected static final class JSerialDataIO {
        private final JSerialData dataObject;

        protected JSerialDataIO(JSerialData dataObject) {
            this.dataObject = dataObject;
        }

        private static String key(SerialDataKeys key) {
            return key.toString();
        }

        private JsonObject getMetadata() {
            return this.dataObject.metadata;
        }

        private JsonObject getData() {
            return this.dataObject.data;
        }

        private void setMetadata(String identification, int version) {
            this.getMetadata().add(JSerialDataIO.key(SerialDataKeys.IDENTIFICATION), (JsonElement)new JsonPrimitive(identification));
            this.getMetadata().add(JSerialDataIO.key(SerialDataKeys.VERSION), (JsonElement)new JsonPrimitive((Number)version));
        }

        private String getIdentification() {
            return this.getMetadata().get(JSerialDataIO.key(SerialDataKeys.IDENTIFICATION)).getAsString();
        }

        private int getVersion() {
            return this.getMetadata().get(JSerialDataIO.key(SerialDataKeys.VERSION)).getAsInt();
        }

        public JSerialData getJSerialData() {
            return this.dataObject;
        }

        public void add(String key, JsonElement value) {
            this.getData().add(key, value);
        }

        public void add(String key, String value) {
            this.getData().add(key, (JsonElement)new JsonPrimitive(value));
        }

        public void add(String key, boolean value) {
            this.getData().add(key, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
        }

        public void add(String key, Number value) {
            this.getData().add(key, (JsonElement)new JsonPrimitive(value));
        }

        public void add(String key, Character value) {
            this.getData().add(key, (JsonElement)new JsonPrimitive(value));
        }

        public boolean has(String key) {
            return this.getData().has(key);
        }

        public JsonElement get(String key) {
            return this.getData().get(key);
        }

        public JsonObject getObject(String key) {
            JsonElement value;
            if (!this.getData().has(key) || !(value = this.getData().get(key)).isJsonObject()) {
                throw new IllegalStateException("Could not get value '" + key + "' as JsonObject from JSerialData.");
            }
            return value.getAsJsonObject();
        }

        public JsonObject getObject(String key, JsonObject defaultValue) {
            JsonElement value = this.get(key);
            if (value != null && value.isJsonObject()) {
                return value.getAsJsonObject();
            }
            return defaultValue;
        }

        public String getString(String key) {
            JsonElement value;
            if (!this.getData().has(key) || !(value = this.getData().get(key)).isJsonPrimitive()) {
                throw new IllegalStateException("Could not get value '" + key + "' as String from JSerialData.");
            }
            return value.getAsString();
        }

        public String getString(String key, String defaultValue) {
            JsonElement value = this.get(key);
            if (value != null && value.isJsonPrimitive()) {
                return value.getAsString();
            }
            return defaultValue;
        }

        public int getInteger(String key) {
            JsonElement value;
            if (!this.getData().has(key) || !(value = this.getData().get(key)).isJsonPrimitive()) {
                throw new IllegalStateException("Could not get value '" + key + "' as Integer from JSerialData.");
            }
            return value.getAsInt();
        }

        public int getInteger(String key, int defaultValue) {
            JsonElement value = this.get(key);
            if (value != null && value.isJsonPrimitive()) {
                return value.getAsInt();
            }
            return defaultValue;
        }

        public boolean getBoolean(String key) {
            JsonElement value;
            if (!this.getData().has(key) || !(value = this.getData().get(key)).isJsonPrimitive()) {
                throw new IllegalStateException("Could not get value '" + key + "' as Boolean from JSerialData.");
            }
            return value.getAsBoolean();
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            JsonElement value = this.get(key);
            if (value != null && value.isJsonPrimitive()) {
                return value.getAsBoolean();
            }
            return defaultValue;
        }

        public long getLong(String key) {
            JsonElement value;
            if (!this.getData().has(key) || !(value = this.getData().get(key)).isJsonPrimitive()) {
                throw new IllegalStateException("Could not get value '" + key + "' as Long from JSerialData.");
            }
            return value.getAsLong();
        }

        public long getLong(String key, long defaultValue) {
            JsonElement value = this.get(key);
            if (value != null && value.isJsonPrimitive()) {
                return value.getAsLong();
            }
            return defaultValue;
        }
    }

    public static class JSerialData {
        private static final Gson INTERNAL_GSON_INSTANCE = new GsonBuilder().setLenient().create();
        private final JSerialDataIO io;
        private final JsonObject metadata;
        private final JsonObject data;

        public static JSerialData fromJsonString(String jsonString) throws IllegalArgumentException, JsonSyntaxException {
            return JSerialData.fromJson((JsonObject)INTERNAL_GSON_INSTANCE.fromJson(jsonString, JsonObject.class));
        }

        public static JSerialData fromJson(JsonObject json) throws IllegalArgumentException {
            JSerialData.validateJSerialDataJson(json);
            return new JSerialData(json.getAsJsonObject(SerialDataKeys.METADATA.key), json.getAsJsonObject(SerialDataKeys.DATA.key));
        }

        private JSerialData(JsonObject metadata, JsonObject data) {
            this.metadata = Objects.requireNonNull(metadata);
            this.data = Objects.requireNonNull(data);
            this.io = new JSerialDataIO(this);
        }

        private JSerialData(JSerializer<?> serializer) {
            this(new JsonObject(), new JsonObject());
            this.io.setMetadata(((JSerializer)serializer).identification, serializer.getVersion());
        }

        protected JsonObject getDataJsonObject() {
            JsonObject serialDataContainer = new JsonObject();
            serialDataContainer.add(SerialDataKeys.METADATA.key, (JsonElement)this.metadata);
            serialDataContainer.add(SerialDataKeys.DATA.key, (JsonElement)this.data);
            return serialDataContainer;
        }

        public String getDataAsJsonString() {
            return this.getDataAsJsonString(INTERNAL_GSON_INSTANCE);
        }

        public String getDataAsJsonString(Gson gson) {
            return Objects.requireNonNull(gson).toJson((JsonElement)this.getDataJsonObject());
        }

        public String getSerializerIdentification() {
            return this.io.getIdentification();
        }

        public int getSerializerVersion() {
            return this.io.getVersion();
        }

        public String toString() {
            return String.format("JSerialData[implementation=%s, identification=%s, version=%s]", this.getClass().getCanonicalName(), this.io.getIdentification(), this.io.getVersion());
        }

        private static void validateJSerialDataJson(JsonObject jSerialDataJson) throws IllegalArgumentException {
            JsonObject metadata = Objects.requireNonNull(jSerialDataJson).getAsJsonObject(SerialDataKeys.METADATA.key);
            JsonObject data = jSerialDataJson.getAsJsonObject(SerialDataKeys.DATA.key);
            if (metadata == null) {
                throw new IllegalArgumentException("Invalid JSerialData json! The 'metadata' member is missing.");
            }
            if (data == null) {
                throw new IllegalArgumentException("Invalid JSerialData json! The 'data' member is missing.");
            }
            JsonPrimitive identification = metadata.getAsJsonPrimitive(SerialDataKeys.IDENTIFICATION.key);
            JsonPrimitive version = metadata.getAsJsonPrimitive(SerialDataKeys.VERSION.key);
            if (identification == null) {
                throw new IllegalArgumentException("Invalid JSerialData metadata! The 'identification' member is missing.");
            }
            if (version == null) {
                throw new IllegalArgumentException("Invalid JSerialData metadata! The 'version' member is missing.");
            }
            String identificationStr = identification.getAsString();
            String versionStr = version.getAsString();
            if (identificationStr.isEmpty()) {
                throw new IllegalArgumentException("Invalid JSerialData metadata! The 'identification' string is empty.");
            }
            if (versionStr.isEmpty()) {
                throw new IllegalArgumentException("Invalid JSerialData metadata! The 'version' string is empty.");
            }
        }
    }

    private static enum SerialDataKeys {
        METADATA("metadata"),
        IDENTIFICATION("identification"),
        VERSION("version"),
        DATA("data");

        public final String key;

        private SerialDataKeys(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }

    public static interface JSerializable<T extends JSerializable<T>> {
        public JSerializer<T> getSerializer();
    }
}

