/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.function.Function;

public final class MathUtil {
    private static final Random RANDOM_INSTANCE = new Random();

    private MathUtil() {
    }

    public static double roundToNDecimals(double input, int decimals) {
        if (decimals < 1) {
            throw new IllegalArgumentException("Cannot have less than 1 decimal point of precision");
        }
        if (decimals > 16) {
            throw new IllegalArgumentException("Cannot have more than 16 decimal points of precision");
        }
        StringBuilder pattern = new StringBuilder("#.");
        for (int i = 0; i < decimals; ++i) {
            pattern.append("#");
        }
        DecimalFormat df = new DecimalFormat(pattern.toString());
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(input).replace(",", "."));
    }

    public static int getRandomIntegerInRange(int min, int max) {
        return MathUtil.getRandomIntegerInRange(RANDOM_INSTANCE, min, max);
    }

    public static int getRandomIntegerInRange(Random random, int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("Maximum integer must be greater than minimum integer");
        }
        return random.nextInt(max - min + 1) + min;
    }

    public static double within(double in, double min, double max) {
        if (in > max) {
            return max;
        }
        return Math.max(in, min);
    }

    public static int within(int in, int min, int max) {
        if (in > max) {
            return max;
        }
        return Math.max(in, min);
    }

    public static long within(long in, long min, long max) {
        if (in > max) {
            return max;
        }
        return Math.max(in, min);
    }

    public static class Probability {
        private final double probability;

        public static Probability newRandomProbability() {
            return new Probability(0.5);
        }

        public static Probability newProbability(double probability) {
            return new Probability(probability);
        }

        public static Probability newPercentageProbability(double percentage) {
            return new Probability(percentage / 100.0);
        }

        public static Probability addProbabilities(Probability a, Probability b) {
            return new Probability(a.getProbability() + b.getProbability());
        }

        public static Probability multiplyProbabilities(Probability a, Probability b) {
            return new Probability(a.getProbability() * b.getProbability());
        }

        private Probability(double probability) {
            this.probability = probability;
        }

        public Result randomResult() {
            if (this.probability <= 0.0) {
                return new Result(false);
            }
            if (this.probability >= 1.0) {
                return new Result(true);
            }
            if (this.probability == 0.5) {
                return new Result(RANDOM_INSTANCE.nextBoolean());
            }
            return new Result((double)RANDOM_INSTANCE.nextFloat() < this.probability);
        }

        public double getProbability() {
            return this.probability;
        }

        public double getProbability(int precision) {
            return MathUtil.roundToNDecimals(this.probability, precision);
        }

        public double getPercentageProbability() {
            return this.probability * 100.0;
        }

        public double getPercentageProbability(int precision) {
            return this.getProbability(precision) * 100.0;
        }

        public static class Result {
            private final boolean value;

            private Result(boolean value) {
                this.value = value;
            }

            public boolean get() {
                return this.value;
            }

            public boolean isTrue() {
                return this.value;
            }

            public boolean isFalse() {
                return !this.isTrue();
            }

            public <T> T action(Function<Boolean, T> action) {
                return action.apply(this.get());
            }

            public <T> T ifTrue(Function<Boolean, T> action) {
                if (this.isTrue()) {
                    return action.apply(this.get());
                }
                return null;
            }

            public <T> T ifFalse(Function<Boolean, T> action) {
                if (this.isFalse()) {
                    return action.apply(this.get());
                }
                return null;
            }
        }
    }
}

