/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;

public class RKey {
    public static final Mode DEFAULT_MODE = Mode.ANY;
    private static final String VALIDATABLE_NAME_PREFIX = "key.keyboard.";
    private final RKeyInternal rKeyInternal = new RKeyInternal();
    @Nullable
    private final String name;
    private final int[] keyCodes;
    private final Mode mode;

    public RKey(int ... keyCodes) {
        this(null, null, keyCodes);
    }

    public RKey(@Nullable String name, int ... keyCodes) {
        this(name, null, keyCodes);
    }

    public RKey(Mode mode, int ... keyCodes) {
        this(null, mode, keyCodes);
    }

    public RKey(@Nullable String name, Mode mode, int ... keyCodes) {
        if (keyCodes == null || keyCodes.length < 1) {
            throw new NullPointerException("Cannot construct RKey with null or 0 length keyCodes array.");
        }
        this.mode = mode == null ? DEFAULT_MODE : mode;
        this.keyCodes = keyCodes;
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean validate() {
        return this.rKeyInternal.validate();
    }

    public boolean query() {
        return this.rKeyInternal.query();
    }

    public int[] getKeyCodes() {
        return this.keyCodes;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isSingle() {
        return this.keyCodes.length == 1;
    }

    public boolean isChained() {
        return this.keyCodes.length > 1;
    }

    public String[] getKeyNamesFromKeyCodes() {
        return this.rKeyInternal.getValidatableKeyCodes();
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasValidatableName() {
        return this.name != null && this.name.startsWith(VALIDATABLE_NAME_PREFIX);
    }

    public boolean canBeValidated() {
        return this.hasValidatableName() && this.isSingle();
    }

    private class RKeyInternal {
        @Nullable
        private InputMappings.Input asInput;
        private boolean validated = false;

        private RKeyInternal() {
        }

        boolean validate() {
            if (RKey.this.isChained()) {
                return false;
            }
            if (this.asInput != null) {
                return this.validated;
            }
            InputMappings.Input inputKeyCode = this.asInput = this.getInputFromCode();
            if (!RKey.this.hasValidatableName()) {
                return false;
            }
            InputMappings.Input inputName = this.getInputFromName();
            if (inputName != null) {
                this.validated = inputName.func_197937_c() == inputKeyCode.func_197937_c();
                return this.validated;
            }
            this.validated = false;
            return false;
        }

        public String[] getValidatableKeyCodes() {
            ArrayList<String> codes = new ArrayList<String>();
            for (int keyCode : RKey.this.keyCodes) {
                codes.add(this.getInputFromCode(keyCode).func_197935_d());
            }
            return codes.toArray(new String[0]);
        }

        boolean query() {
            if (!RKey.this.isChained()) {
                this.validate();
                if (RKey.this.hasValidatableName() && this.asInput != null && !this.validated) {
                    throw new IllegalStateException("RKey '" + RKey.this.name + "' failed validation! RKey with code is: '" + this.asInput.func_197935_d() + "' instead!");
                }
                return this.queryGiven();
            }
            return this.queryGiven();
        }

        private boolean queryGiven() {
            if (RKey.this.isSingle()) {
                return this.queryKeyCode(RKey.this.keyCodes[0]);
            }
            if (RKey.this.isChained()) {
                return this.queryChained();
            }
            return false;
        }

        private boolean queryChained() {
            boolean anyMode = RKey.this.mode == Mode.ANY;
            for (int keyCode : RKey.this.keyCodes) {
                boolean down = this.queryKeyCode(keyCode);
                if (down && anyMode) {
                    return true;
                }
                if (down || anyMode) continue;
                return false;
            }
            return !anyMode;
        }

        private boolean queryKeyCode(int code) {
            return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)code);
        }

        private InputMappings.Input getInputFromCode() {
            return this.getInputFromCode(RKey.this.keyCodes[0]);
        }

        private InputMappings.Input getInputFromCode(int code) {
            return InputMappings.Type.KEYSYM.func_197944_a(code);
        }

        private InputMappings.Input getInputFromName() {
            if (RKey.this.name == null) {
                return null;
            }
            try {
                return InputMappings.func_197955_a((String)RKey.this.name);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static enum Mode {
        ANY,
        ALL;

    }
}

