/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetTooltips;
import com.ki11erwolf.resynth.util.ExpandingTooltip;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public interface Tooltip {
    default public void write(List<ITextComponent> tooltip, World world, ItemStack stack) {
        this.write(tooltip);
    }

    public void write(List<ITextComponent> var1);

    public static String localize(String key, Object ... params) {
        return I18n.func_135052_a((String)key, (Object[])params);
    }

    public static ITextComponent toTextComponent(String str) {
        return new StringTextComponent(str);
    }

    public static boolean areTooltipsEnabled() {
        return ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).areTooltipsEnabled();
    }

    public static List<ITextComponent> addBlankLine(List<ITextComponent> tooltips) {
        tooltips.add((ITextComponent)new StringTextComponent(""));
        return tooltips;
    }

    public static ITextComponent newBlankLine() {
        return new StringTextComponent("");
    }

    public static ITextComponent[] formatLineFeeds(ITextComponent input, TextFormatting lineFormatting) {
        String[] splitInput = input.getString().split("\n");
        StringTextComponent[] output = new StringTextComponent[splitInput.length];
        for (int i = 0; i < splitInput.length; ++i) {
            output[i] = new StringTextComponent(lineFormatting.toString() + splitInput[i]);
        }
        return output;
    }

    public static ITextComponent[] formatLineFeeds(ITextComponent input) {
        String[] splitInput = input.getString().split("\n");
        StringTextComponent[] output = new StringTextComponent[splitInput.length];
        Style previousLine = null;
        for (int i = 0; i < splitInput.length; ++i) {
            output[i] = new StringTextComponent(splitInput[i]).func_230530_a_(previousLine == null ? input.func_150256_b() : previousLine);
            previousLine = output[i].func_150256_b();
        }
        return output;
    }

    public static void addPlantItemOrBlockTooltips(List<ITextComponent> tooltip, PlantSet<?, ?> set, ITextComponent descriptiveTooltip) {
        PlantSetTooltips.addWarningIfBroken(tooltip, set);
        new ExpandingTooltip().setShiftForStats(tooltips -> {
            PlantSetTooltips.setPropertiesTooltip(tooltips, set);
            Tooltip.addBlankLine(tooltips);
        }).write(Tooltip.addBlankLine(tooltip));
        new ExpandingTooltip().setCtrlForDescription(tooltips -> Tooltip.addBlankLine(tooltips).addAll(Arrays.asList(Tooltip.formatLineFeeds(descriptiveTooltip, TextFormatting.DARK_GRAY)))).write(tooltip);
        Tooltip.addBlankLine(tooltip);
    }
}

