/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth;

import com.ki11erwolf.resynth.ResynthCommand;
import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.ResynthFurnaceRecipes;
import com.ki11erwolf.resynth.ResynthWorldGen;
import com.ki11erwolf.resynth.analytics.ConnectEvent;
import com.ki11erwolf.resynth.analytics.ErrorEvent;
import com.ki11erwolf.resynth.analytics.NewUserEvent;
import com.ki11erwolf.resynth.analytics.ResynthAnalytics;
import com.ki11erwolf.resynth.proxy.ClientProxy;
import com.ki11erwolf.resynth.proxy.IProxy;
import com.ki11erwolf.resynth.versioning.ModVersionManager;
import com.ki11erwolf.resynth.versioning.VersionManagerBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.command.ICommand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Logger;

@Mod(modid="resynth", name="Resynth", version="1.3.9", acceptedMinecraftVersions="[1.12.2]", dependencies="after:appliedenergistics2; after:tconstruct; after:forestry; after:thermalfoundation;after:bigreactors;after:waila;after:draconicevolution")
public class ResynthMod {
    public static final String MOD_ID = "resynth";
    public static final String MOD_NAME = "Resynth";
    public static final String MOD_VERSION = "1.3.9";
    public static final String MC_VERSION = "[1.12.2]";
    public static final String MOD_PACKAGE = "com.ki11erwolf.resynth";
    public static final String UPDATE_URL = "https://resynth-minecraft-mod.github.io/mod/versions.json";
    @SidedProxy(clientSide="com.ki11erwolf.resynth.proxy.ClientProxy", serverSide="com.ki11erwolf.resynth.proxy.ServerProxy")
    public static IProxy proxy;
    public static final String MODID_AE2 = "appliedenergistics2";
    public static final String MODID_FORESTRY = "forestry";
    public static final String MODID_TINKERS_CONSTRUCT = "tconstruct";
    public static final String MODID_THERMAL_FOUNDATION = "thermalfoundation";
    public static final String MODID_EXTREME_REACTORS = "bigreactors";
    public static final String MODID_DRACONIC_EVOLUTION = "draconicevolution";
    static final String SERVER_PROXY = "com.ki11erwolf.resynth.proxy.ServerProxy";
    static final String CLIENT_PROXY = "com.ki11erwolf.resynth.proxy.ClientProxy";
    private static final String RESYNTH_NU_FILE = "/resynth.id";
    private static Logger logger;
    private static ResynthWorldGen worldGen;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ResynthMod.wrapError(object -> {
            logger = event.getModLog();
            logger.info("Entering pre-init phase...");
            proxy.preInit(event);
            logger.info("Resynth proxy: " + proxy.getClass().getName());
            if (proxy instanceof ClientProxy) {
                ClientCommandHandler.instance.func_71560_a((ICommand)new ResynthCommand());
                logger.info("Attempting Resynth version check...");
                VersionManagerBuilder resynthVMBuilder = new VersionManagerBuilder(MOD_ID).setEnabled(!ResynthConfig.RESYNTH.disableVersionChecks).setOutOfDateConsoleWarningEnabled(!ResynthConfig.RESYNTH.disableVersionMessage).addVersionJsonFileURL(UPDATE_URL);
                ModVersionManager resynthVersionManager = new ModVersionManager(resynthVMBuilder);
                resynthVersionManager.preInit();
            } else {
                logger.info("Resynth is running server side - skipping version check...");
            }
            ResynthAnalytics.send(new ConnectEvent());
            File resynthFile = new File(event.getModConfigurationDirectory().getAbsolutePath() + RESYNTH_NU_FILE);
            if (!resynthFile.exists()) {
                ResynthAnalytics.send(new NewUserEvent());
                try {
                    boolean create = resynthFile.createNewFile();
                    if (!create) {
                        ResynthMod.getLogger().error("Failed to create Resynth NU file");
                    }
                }
                catch (IOException e) {
                    ResynthMod.getLogger().error("Failed to create Resynth NU file", (Throwable)e);
                }
            }
            return null;
        });
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ResynthMod.wrapError(object -> {
            logger.info("Entering init phase...");
            proxy.init(event);
            worldGen = new ResynthWorldGen();
            worldGen.init();
            ResynthFurnaceRecipes.registerFurnaceRecipes();
            if (!ResynthConfig.RESYNTH.disableDevelopmentHelp) {
                for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
                    ResynthMod.getLogger().info("<Resynth-Development-Help> | Found item: " + ((ResourceLocation)entry.getKey()).func_110624_b() + ":" + ((ResourceLocation)entry.getKey()).func_110623_a());
                }
                for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
                    ResynthMod.getLogger().info("<Resynth-Development-Help> | Found block: " + ((ResourceLocation)entry.getKey()).func_110624_b() + ":" + ((ResourceLocation)entry.getKey()).func_110623_a());
                }
            }
            return null;
        });
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ResynthMod.wrapError(object -> {
            logger.info("Entering post-init phase...");
            proxy.postInit(event);
            return null;
        });
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void wrapError(Function<Void, Void> t) {
        try {
            t.apply(null);
        }
        catch (Exception e) {
            ResynthMod.getLogger().fatal("Error in Resynth init()", (Throwable)e);
            ResynthAnalytics.send(new ErrorEvent());
            throw e;
        }
    }
}

