/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.block.tileEntity.ResynthTileEntity;
import com.ki11erwolf.resynth.item.ResynthItems;
import com.ki11erwolf.resynth.plant.ResynthPlantSets;
import com.ki11erwolf.resynth.plant.block.BlockOrganicPlantOre;
import com.ki11erwolf.resynth.plant.block.BlockPlantBase;
import com.ki11erwolf.resynth.plant.item.ItemPlantProduceBulb;
import com.ki11erwolf.resynth.plant.item.ItemPlantProduceShard;
import com.ki11erwolf.resynth.plant.item.ItemPlantSeeds;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ResynthObjectRegisterer {
    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ResynthItems.getItems());
        for (ResynthBlock resynthBlock : ResynthBlocks.getResynthBlocks()) {
            event.getRegistry().register(new ItemBlock((Block)resynthBlock).setRegistryName(resynthBlock.getRegistryName()));
            if (!(resynthBlock instanceof ResynthTileEntity)) continue;
            GameRegistry.registerTileEntity(((ResynthTileEntity)resynthBlock).getTileEntityClass(), (String)resynthBlock.getRegistryName().toString());
        }
        event.getRegistry().registerAll((IForgeRegistryEntry[])ResynthPlantSets.getSeedItems());
        event.getRegistry().registerAll((IForgeRegistryEntry[])ResynthPlantSets.getShardProduceItems());
        event.getRegistry().registerAll((IForgeRegistryEntry[])ResynthPlantSets.getBulbProduceItems());
        for (ResynthBlock resynthBlock : ResynthPlantSets.getPlantBlocks()) {
            event.getRegistry().register(new ItemBlock((Block)resynthBlock).setRegistryName(resynthBlock.getRegistryName()));
        }
        for (ResynthBlock resynthBlock : ResynthPlantSets.getOrganicOreBlocks()) {
            event.getRegistry().register(new ItemBlock((Block)resynthBlock).setRegistryName(resynthBlock.getRegistryName()));
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ResynthBlocks.getResynthBlocks());
        event.getRegistry().registerAll((IForgeRegistryEntry[])ResynthPlantSets.getPlantBlocks());
        event.getRegistry().registerAll((IForgeRegistryEntry[])ResynthPlantSets.getOrganicOreBlocks());
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class ObjectModelRegisterer {
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            for (Item item : ResynthItems.getItems()) {
                ObjectModelRegisterer.registerModel(item);
            }
            for (ResynthBlock resynthBlock : ResynthBlocks.getResynthBlocks()) {
                ObjectModelRegisterer.registerModel(Item.func_150898_a((Block)resynthBlock));
            }
            for (ItemPlantSeeds itemPlantSeeds : ResynthPlantSets.getSeedItems()) {
                ObjectModelRegisterer.registerModel(itemPlantSeeds);
            }
            for (ItemPlantProduceShard itemPlantProduceShard : ResynthPlantSets.getShardProduceItems()) {
                ObjectModelRegisterer.registerModel(itemPlantProduceShard);
            }
            for (ItemPlantProduceBulb itemPlantProduceBulb : ResynthPlantSets.getBulbProduceItems()) {
                ObjectModelRegisterer.registerModel(itemPlantProduceBulb);
            }
            for (BlockPlantBase blockPlantBase : ResynthPlantSets.getPlantBlocks()) {
                ObjectModelRegisterer.registerModel(Item.func_150898_a((Block)blockPlantBase));
            }
            for (BlockOrganicPlantOre blockOrganicPlantOre : ResynthPlantSets.getOrganicOreBlocks()) {
                ObjectModelRegisterer.registerModel(Item.func_150898_a((Block)blockOrganicPlantOre));
            }
        }

        private static void registerModel(Item i) {
            if (i == null) {
                ResynthMod.getLogger().warn("Null item passed to registerModel(item)");
                return;
            }
            ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)new ModelResourceLocation(i.getRegistryName(), "inventory"));
        }
    }
}

